/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.lazy_recipe.type;

import bottomtextdanny.braincell.base.BCLerp;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientDeserializers;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientState;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRegistryIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.item_predicates.ItemStackPredicate;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ToolIngredient
extends LazyRegistryIngredient {
    private static final Function<String, String> COUNT_DISPLAY = s -> " (" + s + " uses) ";
    private final ItemStackPredicate toolPredicate;
    private final int damage;
    private int leftDamagePointer;
    private int inventoryDamagePointer;
    private int screenItemPointer;
    private int countColor;

    public ToolIngredient(ItemStackPredicate item, int damage) {
        super(LazyIngredientDeserializers.TOOL_DESERIALIZER);
        this.toolPredicate = item;
        this.damage = damage;
    }

    @Override
    public void collectResources(ItemStack inventoryStack) {
        if (this.toolPredicate.test(inventoryStack)) {
            int stackDurability = inventoryStack.m_41776_() - inventoryStack.m_41773_();
            this.inventoryDamagePointer += stackDurability;
        }
    }

    @Override
    public boolean isItemStackRelevant(ItemStack stack) {
        return this.toolPredicate.test(stack);
    }

    @Override
    public List<ItemStack> getRelevantIemStacks() {
        return this.toolPredicate.getDisplayableItems().stream().map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    public boolean iterationOnTake(Inventory inventory, ItemStack iteration) {
        if (this.toolPredicate.test(iteration)) {
            int stackDurability = iteration.m_41776_() - iteration.m_41773_();
            if (stackDurability <= this.leftDamagePointer) {
                inventory.m_36057_(iteration);
                this.leftDamagePointer -= stackDurability;
            } else {
                iteration.m_41721_(iteration.m_41773_() + this.leftDamagePointer);
                this.leftDamagePointer = 0;
            }
        }
        return this.leftDamagePointer <= 0;
    }

    @Override
    public LazyIngredientState resetCollectionData() {
        int oldDamagePointer = this.inventoryDamagePointer;
        this.inventoryDamagePointer = 0;
        if (oldDamagePointer >= this.damage) {
            return LazyIngredientState.MATCH;
        }
        if (oldDamagePointer > 0) {
            return LazyIngredientState.UNFULFILLED_MATCH;
        }
        return LazyIngredientState.NO_MATCH;
    }

    @Override
    public void resetConsumeData() {
        this.inventoryDamagePointer = 0;
        this.leftDamagePointer = this.damage;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreenModification(Inventory inventory) {
        int usesInInventory = 0;
        for (ItemStack stack : inventory.f_35974_) {
            if (!this.toolPredicate.test(stack)) continue;
            usesInInventory += stack.m_41776_() - stack.m_41773_();
        }
        if (usesInInventory >= this.damage) {
            this.countColor = 65280;
        } else if (usesInInventory > 0) {
            double step = (double)usesInInventory / (double)this.damage;
            this.countColor = (int)BCLerp.get((double)step, (double)256.0, (double)196.0) << 16;
            this.countColor += (int)BCLerp.get((double)step, (double)64.0, (double)256.0) << 8;
        } else {
            this.countColor = 0xDD0000;
        }
    }

    @Override
    public boolean filter(Item filterBy) {
        return this.toolPredicate.test(new ItemStack((ItemLike)filterBy));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getCountDisplay() {
        return COUNT_DISPLAY.apply(String.valueOf(this.damage));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getCountDisplayColor() {
        return this.countColor;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Item screenItem() {
        List<Item> list = this.toolPredicate.getDisplayableItems();
        if (list.isEmpty()) {
            return Items.f_42127_;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        this.screenItemPointer = (this.screenItemPointer + 1) % (15 * list.size() - 1);
        return list.get(this.screenItemPointer / 15);
    }

    @Override
    public List<Component> tooltip(TooltipFlag flag) {
        return this.toolPredicate.tooltip(flag);
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        CompoundTag predCompound = new CompoundTag();
        this.toolPredicate.serialize(predCompound);
        compound.m_128405_("pred", this.toolPredicate.getType().getId());
        compound.m_128365_("pred_e", (Tag)predCompound);
        compound.m_128405_("damage", this.damage);
        return compound;
    }

    public ToolIngredient copy() {
        return new ToolIngredient(this.toolPredicate, this.damage);
    }
}

