/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.lazy_recipe.type;

import bottomtextdanny.braincell.base.BCLerp;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientState;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRegistryIngredient;
import bottomtextdanny.dannys_expansion._util.DEStringUtil;
import com.google.common.collect.Streams;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TagIngredient
extends LazyRegistryIngredient {
    private List<Item> cachedItemTagContent = List.of();
    private final TagKey<Item> itemTag;
    private String cachedNormalizedKey;
    private Component cachedHiddenComponent;
    private int screenItemPointer;
    private final int count;
    private int leftCountPointer;
    private int inventoryCountPointer;
    private int countColor;

    public TagIngredient(TagKey<Item> itemTag1, int count1) {
        super(null);
        this.itemTag = itemTag1;
        this.count = count1;
        Connection.doClientSide(() -> {
            this.cachedItemTagContent = Streams.stream((Iterable)Registry.f_122827_.m_206058_(this.itemTag)).map(Holder::m_203334_).collect(Collectors.toList());
            ResourceLocation tagID = this.itemTag.f_203868_();
            this.cachedNormalizedKey = DEStringUtil.normalizeKey(tagID.m_135815_());
            String keyStr = new TranslatableComponent(Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84874_()).getString();
            String decodedInfoText = DEStringUtil.translationWithReplacements("ingredient_tooltip.tag_content_hidden", "@tag", this.cachedNormalizedKey).m_131292_();
            String[] split = decodedInfoText.split("@key", 2);
            if (split.length > 1) {
                this.cachedHiddenComponent = new TextComponent(split[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(keyStr).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)new TextComponent(split[1]).m_130940_(ChatFormatting.GRAY));
            } else {
                decodedInfoText = decodedInfoText.replace("@key", keyStr);
                this.cachedHiddenComponent = new TextComponent(decodedInfoText).m_130940_(ChatFormatting.GRAY);
            }
        });
    }

    @Override
    public void collectResources(ItemStack inventoryStack) {
        if (!inventoryStack.m_41768_() && inventoryStack.m_204117_(this.itemTag)) {
            this.inventoryCountPointer += inventoryStack.m_41613_();
        }
    }

    @Override
    public boolean isItemStackRelevant(ItemStack stack) {
        return stack.m_204117_(this.itemTag);
    }

    @Override
    public List<ItemStack> getRelevantIemStacks() {
        return this.cachedItemTagContent.stream().map(item -> new ItemStack((ItemLike)item, this.count)).collect(Collectors.toList());
    }

    @Override
    public boolean iterationOnTake(Inventory inventory, ItemStack iteration) {
        if (iteration.m_204117_(this.itemTag)) {
            if (iteration.m_41613_() < this.leftCountPointer) {
                inventory.m_36057_(iteration);
                this.leftCountPointer -= iteration.m_41613_();
            } else {
                iteration.m_41764_(iteration.m_41613_() - this.leftCountPointer);
                this.leftCountPointer = 0;
            }
        }
        return this.leftCountPointer <= 0;
    }

    @Override
    public LazyIngredientState resetCollectionData() {
        int oldCountPointer = this.inventoryCountPointer;
        this.inventoryCountPointer = 0;
        if (oldCountPointer >= this.count) {
            return LazyIngredientState.MATCH;
        }
        if (oldCountPointer > 0) {
            return LazyIngredientState.UNFULFILLED_MATCH;
        }
        return LazyIngredientState.NO_MATCH;
    }

    @Override
    public void resetConsumeData() {
        this.leftCountPointer = this.count;
    }

    @Override
    public boolean filter(Item filterBy) {
        return this.cachedItemTagContent.contains(filterBy);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Item screenItem() {
        if (this.cachedItemTagContent != null && this.cachedItemTagContent.size() > 0) {
            this.screenItemPointer = (this.screenItemPointer + 1) % (15 * this.cachedItemTagContent.size() - 1);
            return this.cachedItemTagContent.get(this.screenItemPointer / 15);
        }
        return Items.f_42127_;
    }

    @Override
    public List<Component> tooltip(TooltipFlag flag) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)DEStringUtil.translationWithReplacements("ingredient_tooltip.tag", "@tag", this.cachedNormalizedKey));
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_())) {
            tooltips.add(this.cachedHiddenComponent);
        } else if (this.cachedItemTagContent != null && this.cachedItemTagContent.size() > 0) {
            this.cachedItemTagContent.forEach(item -> tooltips.add((Component)new TextComponent(item.m_7626_(item.m_7968_()).getString()).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
        }
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getCountDisplayColor() {
        return this.countColor;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreenModification(Inventory inventory) {
        int countInInventory = 0;
        for (ItemStack stack : inventory.f_35974_) {
            if (!stack.m_204117_(this.itemTag) || stack.m_41768_() || (countInInventory += stack.m_41613_()) < this.count) continue;
            return;
        }
        if (countInInventory >= this.count) {
            this.countColor = 65280;
        } else if (countInInventory > 0) {
            double step = (double)countInInventory / (double)this.count;
            this.countColor = (int)BCLerp.get((double)step, (double)256.0, (double)196.0) << 16;
            this.countColor += (int)BCLerp.get((double)step, (double)64.0, (double)256.0) << 8;
        } else {
            this.countColor = 0xDD0000;
        }
    }

    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        ResourceLocation mabyTagID = this.itemTag.f_203868_();
        if (mabyTagID != null) {
            compound.m_128359_("tag", mabyTagID.toString());
            compound.m_128405_("count", this.count);
            return compound;
        }
        return compound;
    }

    public TagIngredient copy() {
        return new TagIngredient(this.getItemTag(), this.getCount());
    }
}

