/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.lazy_recipe.type;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientDeserializer;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientDeserializers;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class LazyRecipe {
    public static LazyRecipe EMPTY = new LazyRecipe(-1, null, ItemStack.f_41583_, null);
    private final ResourceLocation resourceLocation;
    private final List<LazyIngredient> ingredients;
    private final ItemStack result;
    private final int index;

    public LazyRecipe(int index, List<LazyIngredient> ingredients, ItemStack result, ResourceLocation resourceLocation) {
        this.ingredients = ingredients;
        this.result = result;
        this.resourceLocation = resourceLocation;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public List<LazyIngredient> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        try {
            compound.m_128359_("data", this.resourceLocation.toString());
            compound.m_128365_("result_stack", (Tag)this.result.serializeNBT());
            ListTag ingList = new ListTag();
            this.ingredients.forEach(ingredient -> {
                CompoundTag ingredientCompound = ingredient.serialize();
                ingredientCompound.m_128405_("index", ingredient.getDeserializationIdentifier().numberIdentifier);
                ingList.add((Object)ingredientCompound);
            });
            compound.m_128365_("ingredients", (Tag)ingList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Braincell.common().logger.info((Object)this.resourceLocation);
        }
        return compound;
    }

    public static LazyRecipe deserialize(int index, CompoundTag compound) {
        LinkedList desIngredients = Lists.newLinkedList();
        ResourceLocation desLocation = new ResourceLocation(compound.m_128461_("data"));
        compound.m_128437_("ingredients", 10).stream().map(tg -> (CompoundTag)tg).forEach(comp -> {
            if (comp.m_128441_("index")) {
                LazyIngredientDeserializer decodeFunc = LazyIngredientDeserializers.DESERIALIZATION_BY_INT_IDENTIFIER.get(comp.m_128451_("index"));
                LazyIngredient ing = decodeFunc.fromNBT.apply((CompoundTag)comp);
                if (ing != null) {
                    desIngredients.add(ing);
                }
            }
        });
        ItemStack desResult = ItemStack.m_41712_((CompoundTag)((CompoundTag)Objects.requireNonNull(compound.m_128423_("result_stack"), "lazy ingredient result couldn't be read. " + desLocation)));
        return new LazyRecipe(index, desIngredients, desResult, desLocation);
    }
}

