/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.lazy_recipe.type;

import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.ItemIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.ItemStackPredicateTypes;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientDeserializer;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.ToolIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.item_predicates.ItemStackPredicate;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.item_predicates.ItemStackPredicateType;
import bottomtextdanny.dannys_expansion._util.JsonReadUtil;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class LazyIngredientDeserializers {
    public static final Map<Integer, LazyIngredientDeserializer> DESERIALIZATION_BY_INT_IDENTIFIER = new HashMap<Integer, LazyIngredientDeserializer>();
    public static final Map<String, LazyIngredientDeserializer> DESERIALIZATION_BY_STR_IDENTIFIER = new HashMap<String, LazyIngredientDeserializer>();
    private static int numberIdentifier;
    public static final LazyIngredientDeserializer ITEM_DESERIALIZER;
    public static final LazyIngredientDeserializer TOOL_DESERIALIZER;

    @NotNull
    private static ItemStackPredicateType<?> searchType(String name) {
        ItemStackPredicateType<?> type = ItemStackPredicateType.getByKey(name.charAt(0));
        if (type != null) {
            return type;
        }
        return ItemStackPredicateTypes.ITEM;
    }

    public static LazyIngredientDeserializer add(LazyIngredientDeserializer deserializer) {
        DESERIALIZATION_BY_INT_IDENTIFIER.put(deserializer.numberIdentifier, deserializer);
        DESERIALIZATION_BY_STR_IDENTIFIER.put(deserializer.stringIdentifier, deserializer);
        return deserializer;
    }

    public static void loadClass() {
    }

    static {
        ITEM_DESERIALIZER = LazyIngredientDeserializers.add(new LazyIngredientDeserializer(numberIdentifier++, "item", compound -> {
            ItemStackPredicate predicate = (ItemStackPredicate)ItemStackPredicateType.getById(compound.m_128451_("pred")).getTagDeserializer().apply(compound.m_128469_("pred_e"));
            return new ItemIngredient(predicate, compound.m_128451_("count"));
        }, jsonObj -> {
            Map.Entry predicateElement = (Map.Entry)jsonObj.entrySet().iterator().next();
            ItemStackPredicateType<?> predType = LazyIngredientDeserializers.searchType((String)predicateElement.getKey());
            ItemStackPredicate predicate = (ItemStackPredicate)predType.getJsonDeserializer().apply((JsonElement)predicateElement.getValue());
            return new ItemIngredient(predicate, JsonReadUtil.getInt(jsonObj, "count"));
        }));
        TOOL_DESERIALIZER = LazyIngredientDeserializers.add(new LazyIngredientDeserializer(numberIdentifier++, "tool", compound -> {
            ItemStackPredicate predicate = (ItemStackPredicate)ItemStackPredicateType.getById(compound.m_128451_("pred")).getTagDeserializer().apply(compound.m_128469_("pred_e"));
            return new ToolIngredient(predicate, compound.m_128451_("damage"));
        }, jsonObj -> {
            Map.Entry predicateElement = (Map.Entry)jsonObj.entrySet().iterator().next();
            ItemStackPredicateType<?> predType = LazyIngredientDeserializers.searchType((String)predicateElement.getKey());
            ItemStackPredicate predicate = (ItemStackPredicate)predType.getJsonDeserializer().apply((JsonElement)predicateElement.getValue());
            return new ItemIngredient(predicate, JsonReadUtil.getInt(jsonObj, "damage"));
        }));
    }
}

