/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.lazy_recipe.type;

import bottomtextdanny.braincell.base.BCLerp;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientDeserializers;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientState;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRegistryIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.item_predicates.ItemStackPredicate;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemIngredient
extends LazyRegistryIngredient {
    private final ItemStackPredicate itemPredicate;
    private final int count;
    private int leftCountPointer;
    private int inventoryCountPointer;
    private int screenItemPointer;
    private int countColor;

    public ItemIngredient(ItemStackPredicate item, int count) {
        super(LazyIngredientDeserializers.ITEM_DESERIALIZER);
        this.itemPredicate = item;
        this.count = count;
    }

    @Override
    public void collectResources(ItemStack inventoryStack) {
        if (this.itemPredicate.test(inventoryStack) && !inventoryStack.m_41768_()) {
            this.inventoryCountPointer += inventoryStack.m_41613_();
        }
    }

    @Override
    public boolean isItemStackRelevant(ItemStack stack) {
        return this.itemPredicate.test(stack);
    }

    @Override
    public List<ItemStack> getRelevantIemStacks() {
        return this.itemPredicate.getDisplayableItems().stream().map(item -> new ItemStack((ItemLike)item, this.count)).collect(Collectors.toList());
    }

    @Override
    public boolean iterationOnTake(Inventory inventory, ItemStack iteration) {
        if (this.itemPredicate.test(iteration)) {
            if (iteration.m_41613_() <= this.leftCountPointer) {
                inventory.m_36057_(iteration);
                this.leftCountPointer -= iteration.m_41613_();
            } else {
                iteration.m_41764_(iteration.m_41613_() - this.leftCountPointer);
                this.leftCountPointer = 0;
            }
        }
        return this.leftCountPointer <= 0;
    }

    @Override
    public LazyIngredientState resetCollectionData() {
        int oldCountPointer = this.inventoryCountPointer;
        this.inventoryCountPointer = 0;
        if (oldCountPointer >= this.count) {
            return LazyIngredientState.MATCH;
        }
        if (oldCountPointer > 0) {
            return LazyIngredientState.UNFULFILLED_MATCH;
        }
        return LazyIngredientState.NO_MATCH;
    }

    @Override
    public void resetConsumeData() {
        this.inventoryCountPointer = 0;
        this.leftCountPointer = this.count;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getCountDisplayColor() {
        return this.countColor;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreenModification(Inventory inventory) {
        int countInInventory = 0;
        for (ItemStack stack : inventory.f_35974_) {
            if (!this.itemPredicate.test(stack) || stack.m_41768_()) continue;
            countInInventory += stack.m_41613_();
        }
        if (countInInventory >= this.count) {
            this.countColor = 65280;
        } else if (countInInventory > 0) {
            double step = (double)countInInventory / (double)this.count;
            this.countColor = (int)BCLerp.get((double)step, (double)256.0, (double)196.0) << 16;
            this.countColor += (int)BCLerp.get((double)step, (double)64.0, (double)256.0) << 8;
        } else {
            this.countColor = 0xDD0000;
        }
    }

    @Override
    public boolean filter(Item filterBy) {
        return this.itemPredicate.test(new ItemStack((ItemLike)filterBy));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Item screenItem() {
        List<Item> list = this.itemPredicate.getDisplayableItems();
        if (list.isEmpty()) {
            return Items.f_42127_;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        this.screenItemPointer = (this.screenItemPointer + 1) % (15 * list.size() - 1);
        return list.get(this.screenItemPointer / 15);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> tooltip(TooltipFlag flag) {
        return this.itemPredicate.tooltip(flag);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        CompoundTag predCompound = new CompoundTag();
        this.itemPredicate.serialize(predCompound);
        compound.m_128405_("pred", this.itemPredicate.getType().getId());
        compound.m_128365_("pred_e", (Tag)predCompound);
        compound.m_128405_("count", this.count);
        return compound;
    }

    public ItemIngredient copy() {
        return new ItemIngredient(this.itemPredicate, this.getCount());
    }
}

