/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.lazy_recipe;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.function.Clearable;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.DECommonConfig;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.LazyRecipeType;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredient;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientDeserializer;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyIngredientDeserializers;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.LazyRecipe;
import bottomtextdanny.dannys_expansion._util.JsonReadUtil;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class LazyRecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Map<String, Supplier<Boolean>> CONDITIONS = (Map)Util.m_137537_(() -> {
        HashMap<String, Supplier<Boolean>> map = new HashMap<String, Supplier<Boolean>>();
        DECommonConfig config = DannysExpansion.common().config();
        map.put("gun", config::guns);
        return map;
    });
    private static final String CONDITION_TAG = "con";
    private static final String INGREDIENTS_TAG = "ingredients";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final BiMap<Integer, LazyRecipeType> transientIdToRecipe = HashBiMap.create();
    private final Map<ResourceLocation, LazyRecipeType> keyToRecipe = Maps.newHashMap();
    private final Map<LazyRecipeType, List<LazyRecipe>> recipes = new IdentityHashMap<LazyRecipeType, List<LazyRecipe>>();
    private final Clearable<Map<LazyRecipeType, List<LazyRecipe>>> unmodifiableRecipes = Clearable.of(() -> {
        IdentityHashMap map = new IdentityHashMap();
        this.recipes.forEach((type, typeRecipes) -> map.put(type, Collections.unmodifiableList(typeRecipes)));
        return map;
    });

    public LazyRecipeManager(String directory) {
        super(GSON, directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.resetRecipeCache();
        MutableBoolean wrongedTypes = new MutableBoolean(false);
        objectIn.entrySet().stream().sorted(Comparator.comparingInt(entry -> JsonReadUtil.getInt(((JsonElement)entry.getValue()).getAsJsonObject(), "index", Integer.MAX_VALUE))).forEach(e -> {
            ResourceLocation id = (ResourceLocation)e.getKey();
            JsonElement element = (JsonElement)e.getValue();
            JsonObject file = element.getAsJsonObject();
            if (file.has(CONDITION_TAG) && !CONDITIONS.get(JsonReadUtil.getString(file, CONDITION_TAG)).get().booleanValue()) {
                return;
            }
            ResourceLocation typeRl = new ResourceLocation(JsonReadUtil.getString(file, "type"));
            LazyRecipeType type = this.keyToRecipe.get(typeRl);
            if (type != null) {
                LinkedList ingredients = Lists.newLinkedList();
                JsonArray jsonIngredients = JsonReadUtil.getJsonArray(file, INGREDIENTS_TAG);
                jsonIngredients.forEach(jsonElement -> LazyRecipeManager.readIngredient(jsonElement.getAsJsonObject(), ingredients));
                JsonObject jsonResult = JsonReadUtil.getJsonObject(file, "result");
                ItemStack itemStack = new ItemStack((ItemLike)JsonReadUtil.getItem(jsonResult, "item"));
                itemStack.m_41764_(JsonReadUtil.getInt(jsonResult, "count"));
                if (!this.recipes.containsKey(type)) {
                    this.recipes.put(type, Lists.newArrayList());
                }
                LazyRecipe recipe = new LazyRecipe(this.recipes.get(type).size(), ingredients, itemStack, id);
                this.recipes.get(type).add(recipe);
            } else {
                wrongedTypes.setTrue();
                DannysExpansion.common().logger.warn("Couldn't match a lazy recipe type with string \"{}\".", (Object)typeRl);
            }
        });
        if (wrongedTypes.booleanValue()) {
            DannysExpansion.common().logger.info("\nHere is a list of all existing lazy recipe types:");
            this.keyToRecipe.forEach((rl, type) -> DannysExpansion.common().logger.info("{} with transient id {}.", rl, type));
        }
    }

    public static void readIngredient(JsonObject object, Collection<? super LazyIngredient> collection) {
        Map.Entry[] elementArray = (Map.Entry[])object.entrySet().toArray(Map.Entry[]::new);
        if (elementArray.length > 0) {
            LazyIngredient ingredientType;
            LazyIngredientDeserializer deserializerFound = LazyIngredientDeserializers.DESERIALIZATION_BY_STR_IDENTIFIER.get(elementArray[0].getKey());
            if (deserializerFound == null) {
                deserializerFound = LazyIngredientDeserializers.DESERIALIZATION_BY_STR_IDENTIFIER.get(((String)elementArray[0].getKey()).substring(1));
            }
            if ((ingredientType = deserializerFound.fromJSON.apply(object)) != null) {
                collection.add(ingredientType);
            }
        }
    }

    public Map<LazyRecipeType, List<LazyRecipe>> getAllRecipes() {
        return this.recipes;
    }

    public void addRecipe(LazyRecipeType type, LazyRecipe recipe) {
        this.recipes.get(type).add(recipe);
    }

    public LazyRecipe getRecipe(LazyRecipeType type, int index) {
        if (index == -1) {
            return LazyRecipe.EMPTY;
        }
        return this.recipes.get(type).get(index);
    }

    public List<LazyRecipe> getRecipes(LazyRecipeType type) {
        return this.recipes.get(type);
    }

    public void resetRecipeCache() {
        for (Map.Entry<LazyRecipeType, List<LazyRecipe>> entry : this.recipes.entrySet()) {
            LazyRecipeType type = entry.getKey();
            List<LazyRecipe> list = entry.getValue();
            list.clear();
        }
    }

    public void tryAddType(LazyRecipeType type) {
        if (Braincell.common().hasPassedInitialization()) {
            throw new UnsupportedOperationException("Cannot register new lazy recipe types after mod loading phase.");
        }
        this.keyToRecipe.putIfAbsent(type.getKey(), type);
        this.transientIdToRecipe.put((Object)this.transientIdToRecipe.size(), (Object)type);
        this.recipes.put(type, Lists.newArrayList());
    }

    public int getTypeId(LazyRecipeType type) {
        return (Integer)this.transientIdToRecipe.inverse().get((Object)type);
    }

    public LazyRecipeType getTypeById(int type) {
        return (LazyRecipeType)this.transientIdToRecipe.get((Object)type);
    }

    public int recipeTypeSize() {
        return this.keyToRecipe.size();
    }

    public int size() {
        MutableInt size = new MutableInt(0);
        this.recipes.forEach((type, typeRecipes) -> size.addAndGet(typeRecipes.size()));
        return this.recipes.size();
    }
}

