/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.gun_rendering;

import bottomtextdanny.braincell.base.vector.DistanceCalc3;
import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.gun_rendering.GunClientData;
import bottomtextdanny.dannys_expansion._base.gun_rendering.GunModelRenderer;
import bottomtextdanny.dannys_expansion._base.gun_rendering.ScopeRenderingData;
import bottomtextdanny.dannys_expansion._util._client.CMC;
import bottomtextdanny.dannys_expansion.content.items.bow.DEBowItem;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import bottomtextdanny.dannys_expansion.content.items.gun.ScopingGun;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;

@OnlyIn(value=Dist.CLIENT)
public final class GunRenderingManager {
    private final Map<GunItem<?>, GunModelRenderer> rendererByGun = Maps.newIdentityHashMap();
    private final Map<ScopingGun, ScopeRenderingData> scopeTexturesByGun = Maps.newIdentityHashMap();

    public GunRenderingManager() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(event -> this.handlePlayerModel(event.getPlayer(), event.getModel()));
        bus.addListener(this::handleLevelCamera);
        bus.addListener(this::handleHandRendering);
        bus.addListener(this::handleClickInput);
        bus.addListener(this::handleMovementInput);
    }

    public void handlePlayerModel(AbstractClientPlayer player, PlayerModel<?> model) {
        if (player.m_6084_() && player.m_21211_() == ItemStack.f_41583_) {
            boolean rightHanded = player.m_5737_() == HumanoidArm.RIGHT;
            ModelPart mainHand = rightHanded ? model.f_102811_ : model.f_102812_;
            ModelPart offHand = rightHanded ? model.f_102812_ : model.f_102811_;
            PlayerGunModule gunModule = PlayerHelper.gunModule((Player)player);
            float handSignStep = rightHanded ? 1.0f : -1.0f;
            float radianStep = handSignStep * ((float)Math.PI / 180);
            float easedRecoil = Mth.m_14179_((float)BCStaticData.partialTick(), (float)gunModule.getPrevRecoil(), (float)gunModule.getRecoil());
            if (!player.m_6067_()) {
                if (player.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof GunItem) {
                    mainHand.f_104203_ = Math.max(model.f_102808_.f_104203_ - (float)Math.PI / 180 * (90.0f + easedRecoil), -3.577925f);
                    mainHand.f_104204_ = model.f_102808_.f_104204_ + (float)Math.PI / 180;
                    offHand.f_104200_ = (float)((double)offHand.f_104200_ + (double)(-handSignStep) * 1.5);
                    offHand.f_104203_ = Math.max(model.f_102808_.f_104203_ - (float)Math.PI / 180 * (77.0f + easedRecoil), -3.3161256f);
                    offHand.f_104204_ = Mth.m_14036_((float)(model.f_102808_.f_104204_ + radianStep * 50.0f), (float)-1.2217305f, (float)1.2217305f);
                    model.f_102808_.f_104203_ += (float)Math.PI / 180 * (0.2f * -easedRecoil);
                } else if (player.m_6844_(EquipmentSlot.OFFHAND).m_41720_() instanceof GunItem) {
                    mainHand = rightHanded ? model.f_102812_ : model.f_102811_;
                    offHand = rightHanded ? model.f_102811_ : model.f_102812_;
                    handSignStep = rightHanded ? -1.0f : 1.0f;
                    mainHand.f_104203_ = Math.max(model.f_102808_.f_104203_ - (float)Math.PI / 180 * (90.0f + easedRecoil), -3.577925f);
                    mainHand.f_104204_ = model.f_102808_.f_104204_ + (float)Math.PI / 180;
                    offHand.f_104200_ = (float)((double)offHand.f_104200_ + (double)(-handSignStep) * 1.5);
                    offHand.f_104203_ = Math.max(model.f_102808_.f_104203_ - (float)Math.PI / 180 * (77.0f + easedRecoil), -3.3161256f);
                    offHand.f_104204_ = Mth.m_14036_((float)(model.f_102808_.f_104204_ + radianStep * -50.0f), (float)-1.2217305f, (float)1.2217305f);
                }
                model.f_102808_.f_104203_ = Math.max(model.f_102808_.f_104203_ + (float)Math.PI / 180 * (0.1f * -easedRecoil), -3.2288592f);
            }
        }
    }

    public void handleLevelTick() {
        LocalPlayer player = CMC.player();
        GunClientData gunData = DannysExpansion.client().getGunData();
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (player != null && gunData != null) {
            boolean hasGun = false;
            gunData.itemUseCountO = player.m_21252_();
            gunData.pitchRecoilO = gunData.pitchRecoil;
            gunData.recoilO = gunData.recoil;
            gunData.renderDispersionO = gunData.renderDispersion;
            for (InteractionHand hand : InteractionHand.values()) {
                Item itemInHand = player.m_21120_(hand).m_41720_();
                if (hasGun || !(itemInHand instanceof GunItem)) continue;
                GunItem gunInHand = (GunItem)itemInHand;
                float movement = (float)DistanceCalc3.EUCLIDEAN.distance(player.f_19790_, player.f_19791_, player.f_19792_, player.m_20185_(), player.m_20186_(), player.m_20189_());
                gunInHand.updateClientDispersion((Player)player, gunData.recoil, movement);
                hasGun = true;
            }
            if (gunData.recoil > 0.0f) {
                gunData.recoil = Mth.m_14036_((float)(gunData.recoil * gunData.recoilMult - gunData.recoilSubtract), (float)0.0f, (float)Float.MAX_VALUE);
            }
            gunData.pitchRecoil = Mth.m_14036_((float)(gunData.pitchRecoil * gunData.pitchRecoilMult - gunData.pitchRecoilSubtract), (float)0.0f, (float)Float.MAX_VALUE);
            gunData.renderDispersion += (gunData.dispersion - gunData.renderDispersion) * 0.6;
        }
    }

    private void handleLevelCamera(EntityViewRenderEvent.CameraSetup event) {
        LocalPlayer player = CMC.player();
        if (player != null && player.m_6084_()) {
            GunClientData data = DannysExpansion.client().getGunData();
            PlayerGunModule gunModule = PlayerHelper.gunModule((Player)player);
            float pitchRecoil = (float)Mth.m_14139_((double)event.getPartialTicks(), (double)data.pitchRecoilO, (double)data.pitchRecoil);
            float rollRecoil = pitchRecoil * 0.3f * (float)data.rollDirection;
            float offsetFactor = 0.07f;
            event.setRoll(event.getRoll() - rollRecoil);
            if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                event.setPitch(event.getPitch() - pitchRecoil);
            }
            if (gunModule.getGunScoping().m_41720_() instanceof ScopingGun) {
                offsetFactor *= 1.0f - ((ScopingGun)gunModule.getGunScoping().m_41720_()).scopingSensMult();
            }
            if (!Minecraft.m_91087_().m_91104_()) {
                data.pitchO = data.pitch;
            }
            data.yawO = data.yaw;
            data.pitch = Mth.m_14179_((float)offsetFactor, (float)data.pitch, (float)event.getPitch());
            data.yaw = Mth.m_14179_((float)offsetFactor, (float)data.yaw, (float)event.getYaw());
        }
    }

    public void handleMovementInput(MovementInputUpdateEvent event) {
        PlayerGunModule gunModule;
        Item item;
        LocalPlayer player = CMC.player();
        if (player == null || !player.m_6084_()) {
            return;
        }
        ItemStack useItemStack = player.m_21211_();
        Item item2 = useItemStack.m_41720_();
        float mult = 1.0f;
        if (item2 instanceof DEBowItem) {
            DEBowItem bow = (DEBowItem)item2;
            mult = bow.getNockMovementSpeed(player.f_19853_, (Player)player, useItemStack) * 5.0f;
        }
        if ((item = (gunModule = PlayerHelper.gunModule((Player)player)).getGunScoping().m_41720_()) instanceof ScopingGun) {
            ScopingGun scopingGun = (ScopingGun)item;
            mult = scopingGun.scopingMovementSpeed(gunModule.getGunScoping(), (Player)player);
        }
        event.getInput().f_108567_ *= mult;
        event.getInput().f_108566_ *= mult;
    }

    public void handleClickInput(InputEvent.ClickInputEvent event) {
        LocalPlayer player = CMC.player();
        if (player == null || !player.m_6084_()) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            if (event.getKeyMapping() != Minecraft.m_91087_().f_91066_.f_92096_ || !(player.m_21120_(hand).m_41720_() instanceof GunItem)) continue;
            event.setCanceled(true);
            event.setSwingHand(false);
            return;
        }
    }

    private void handleHandRendering(RenderHandEvent event) {
        LocalPlayer player = CMC.player();
        if (player == null || !player.m_6084_()) {
            return;
        }
        PlayerGunModule gunModule = PlayerHelper.gunModule((Player)player);
        if (gunModule.getGunScoping().m_41720_() instanceof ScopingGun) {
            event.setCanceled(true);
        }
    }

    public void putRenderer(GunItem<?> item, GunModelRenderer renderer) {
        this.rendererByGun.put(item, renderer);
    }

    public void putScopeResources(ScopingGun item, ScopeRenderingData resources) {
        this.scopeTexturesByGun.put(item, resources);
    }

    public GunModelRenderer getRenderer(GunItem<?> gunItem) {
        return this.rendererByGun.get(gunItem);
    }

    public ScopeRenderingData getScopeData(ScopingGun gunItem) {
        return this.scopeTexturesByGun.get(gunItem);
    }
}

