/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.capabilities.world;

import bottomtextdanny.braincell.mod.capability.CapabilityModule;
import bottomtextdanny.braincell.mod.capability.CapabilityWrap;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelCapability;
import bottomtextdanny.dannys_expansion._base.network.servertoclient.world.MSGUpdateWindState;
import bottomtextdanny.dannys_expansion._util.DEMath;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public class LevelWindModule
extends CapabilityModule<Level, LevelCapability> {
    public static final String DIRECTION_BIAS_TAG = "direction_bias";
    public static final String WIND_DIRECTION_TAG = "wind_direction";
    public static final String WIND_STRENGTH_TAG = "wind_strength";
    public static final String WIND_DIRECTION_QUERY_TAG = "wind_direction_query";
    public static final String WIND_STOPPED_TAG = "wind_stopped";
    private Direction biasedTowards = Direction.NORTH;
    private float windDirection;
    private float windStrength;
    private boolean isWindStopped;
    private float windDirectionQuery;

    public LevelWindModule(LevelCapability capability) {
        super("wind", (CapabilityWrap)capability);
    }

    public void tick() {
        if (!((Level)this.getHolder()).f_46443_) {
            this.windStrength = this.calculateWindStrength();
            this.windDirection = DEMath.approachDegrees(this.windStrength * 0.4f, this.windDirection, this.windDirectionQuery);
            if (this.windDirection == this.windDirectionQuery) {
                this.windDirectionQuery = DEMath.wrapDegrees(this.biasedTowards.m_122435_() + (float)((Level)this.getHolder()).f_46441_.nextGaussian() * (this.windStrength + 4.0f) * 8.0f);
            }
        }
    }

    private float calculateWindStrength() {
        if (((Level)this.getHolder()).f_46443_) {
            return 0.0f;
        }
        if (((Level)this.getHolder()).m_46470_()) {
            return 15.0f;
        }
        if (((Level)this.getHolder()).m_46471_()) {
            return 10.0f;
        }
        return 7.5f;
    }

    public void updateFromPacket(MSGUpdateWindState windPacket) {
        this.windDirection = windPacket.getWindDirection();
        this.windStrength = windPacket.getWindStrength();
        this.isWindStopped = windPacket.isWindStopped();
    }

    public float getWindDirection() {
        return this.windDirection;
    }

    public float getWindStrength() {
        return this.windStrength;
    }

    public boolean isWindStopped() {
        return this.isWindStopped;
    }

    public void serializeNBT(CompoundTag nbt) {
        nbt.m_128344_(DIRECTION_BIAS_TAG, (byte)this.biasedTowards.m_122416_());
        nbt.m_128350_(WIND_DIRECTION_TAG, this.windDirection);
        nbt.m_128350_(WIND_STRENGTH_TAG, this.windStrength);
        nbt.m_128350_(WIND_DIRECTION_QUERY_TAG, this.windDirectionQuery);
        nbt.m_128379_(WIND_STOPPED_TAG, this.isWindStopped);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.biasedTowards = Direction.m_122407_((int)nbt.m_128445_(DIRECTION_BIAS_TAG));
        this.windDirection = nbt.m_128457_(WIND_DIRECTION_TAG);
        this.windStrength = nbt.m_128457_(WIND_STRENGTH_TAG);
        this.windDirectionQuery = nbt.m_128457_(WIND_DIRECTION_QUERY_TAG);
        this.isWindStopped = nbt.m_128471_(WIND_STOPPED_TAG);
    }
}

