/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.capabilities.world;

import bottomtextdanny.braincell.mod.capability.CapabilityModule;
import bottomtextdanny.braincell.mod.capability.CapabilityWrap;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public class LevelPhaseModule
extends CapabilityModule<Level, LevelCapability> {
    private static final String PHASE_TAG = "phase";
    private Phase phase = Phase.NORMAL;

    public LevelPhaseModule(LevelCapability capability) {
        super(PHASE_TAG, (CapabilityWrap)capability);
    }

    public void assertPhase(Phase assertedPhase) {
        if (assertedPhase.ordinal() > this.phase.ordinal()) {
            this.phase = assertedPhase;
        }
    }

    public void forcePhase(Phase newPhase) {
        this.phase = newPhase;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void serializeNBT(CompoundTag nbt) {
        nbt.m_128344_(PHASE_TAG, (byte)this.phase.ordinal());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.phase = Phase.values()[nbt.m_128445_(PHASE_TAG)];
    }

    public static enum Phase {
        NORMAL("normal"),
        DRAGON("post_dragon");

        public static final Map<String, Integer> STRING_TO_ORDINAL;
        public static Iterable<String> names;
        public static Iterable<String> ordinals;
        public final String name;

        private Phase(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            STRING_TO_ORDINAL = Arrays.stream(Phase.values()).collect(Collectors.toMap(Phase::getName, Enum::ordinal));
            names = Arrays.stream(Phase.values()).map(Phase::getName).collect(Collectors.toCollection(ArrayList::new));
            ordinals = Arrays.stream(Phase.values()).map(phase -> String.valueOf(phase.ordinal())).collect(Collectors.toCollection(ArrayList::new));
        }
    }
}

