/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.capabilities.player;

import bottomtextdanny.braincell.mod.capability.CapabilityModule;
import bottomtextdanny.braincell.mod.capability.CapabilityWrap;
import bottomtextdanny.braincell.mod.capability.level.speck.ShootLighSpeck;
import bottomtextdanny.braincell.mod.graphics.point_lighting.IPointLight;
import bottomtextdanny.braincell.mod.graphics.point_lighting.SimplePointLight;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerCapability;
import bottomtextdanny.dannys_expansion._base.gun_rendering.GunClientData;
import bottomtextdanny.dannys_expansion._base.network.servertoclient.MSGUpdateGunCooldown;
import bottomtextdanny.dannys_expansion._util._client.CMC;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class PlayerGunModule
extends CapabilityModule<Player, PlayerCapability> {
    private float recoil;
    private float prevRecoil;
    private float recoilSubstract;
    private float recoilMultiplier;
    private ItemStack gunScoping = ItemStack.f_41583_;
    private ItemStack previousGun = ItemStack.f_41583_;
    private int gunUseTicks;
    private int gunCooldownTicks;
    @Nullable
    public ResourceLocation fireAnimation;
    public int fireTimer;
    public int fireTicks;

    public PlayerGunModule(PlayerCapability capability) {
        super("gun_handler", (CapabilityWrap)capability);
    }

    public void preTick() {
    }

    public void tick() {
        if (!((Player)this.getHolder()).f_19853_.f_46443_) {
            this.syncToClientIfShould();
        } else if (this.fireTicks > 0) {
            --this.fireTicks;
        } else {
            this.fireAnimation = null;
        }
        Item item = this.previousGun.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            int usageTime = gunItem.usageTime();
            if (usageTime > 0) {
                this.tickShoot(gunItem, usageTime);
            }
            if (this.gunCooldownTicks > 0) {
                --this.gunCooldownTicks;
            }
            this.tickRetrieveFactor();
        }
        this.prevRecoil = this.recoil;
        if (this.recoil > 0.0f) {
            this.recoil = Math.max(this.recoil * this.recoilMultiplier - this.recoilSubstract, 0.0f);
        }
    }

    private void tickShoot(GunItem<?> gunItem, int usageTime) {
        if (this.gunUseTicks >= 0 && this.gunUseTicks < usageTime) {
            ++this.gunUseTicks;
            gunItem.usageTick((Player)this.getHolder(), this, this.previousGun, this.gunUseTicks);
        }
    }

    private void syncToClientIfShould() {
        boolean needsUpdate = true;
        InteractionHand updatedHand = InteractionHand.MAIN_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack handStack = ((Player)this.getHolder()).m_21120_(hand);
            Item item = handStack.m_41720_();
            if (!(item instanceof GunItem)) continue;
            GunItem gun = (GunItem)item;
            needsUpdate = false;
            updatedHand = hand;
            if (handStack == this.previousGun) break;
            this.previousGun = handStack;
            this.gunCooldownTicks = gun.cooldown();
            this.gunUseTicks = -1;
            this.setGunScoping(ItemStack.f_41583_);
            new MSGUpdateGunCooldown(((Player)this.getHolder()).m_142049_(), hand.ordinal()).sendTo(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.getHolder()));
            break;
        }
        if (needsUpdate) {
            this.gunCooldownTicks = -1;
            this.previousGun = ((Player)this.getHolder()).m_21120_(updatedHand);
            this.setGunScoping(ItemStack.f_41583_);
            new MSGUpdateGunCooldown(((Player)this.getHolder()).m_142049_(), updatedHand.ordinal()).sendTo(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.getHolder()));
        }
    }

    private void tickRetrieveFactor() {
        Connection.doClientSide(() -> this.tickRetrieveFactorClient());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickRetrieveFactorClient() {
        GunClientData gunData = DannysExpansion.client().getGunData();
        if (!Minecraft.m_91087_().m_91104_() && this.getHolder() == CMC.player() && gunData.retrieveFactor > 0) {
            --gunData.retrieveFactor;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fireAnimation(ResourceLocation texture) {
        this.fireTimer = 3;
        this.fireTicks = 2;
        this.fireAnimation = texture;
        ShootLighSpeck light = new ShootLighSpeck(((Player)this.getHolder()).f_19853_, 0, 1, 2);
        light.setPosition(((Player)this.getHolder()).m_20182_().m_82520_(0.0, 1.5, 0.0));
        SimplePointLight renderedLight = new SimplePointLight(new Vec3(1.0, (double)0.85f, 0.0), 2.5f, 0.2f, 0.5f);
        light.setLight((IPointLight)renderedLight);
        light.addToLevel();
    }

    public void setPreviousGun(ItemStack previousGun) {
        this.previousGun = previousGun;
    }

    public void setGunUseTicks(int gunUseTicks) {
        this.gunUseTicks = gunUseTicks;
    }

    public void setGunCooldownTicks(int gunCooldownTicks) {
        this.gunCooldownTicks = gunCooldownTicks;
    }

    public void setRecoil(float recoil) {
        this.recoil = recoil;
    }

    public void setPrevRecoil(float prevRecoil) {
        this.prevRecoil = prevRecoil;
    }

    public void setRecoilMultiplier(float recoilMultiplier) {
        this.recoilMultiplier = recoilMultiplier;
    }

    public void setRecoilSubstract(float recoilSubstract) {
        this.recoilSubstract = recoilSubstract;
    }

    public void setGunScoping(ItemStack gunScoping) {
        this.gunScoping = Objects.requireNonNullElse(gunScoping, ItemStack.f_41583_);
    }

    public ItemStack getPreviousGun() {
        return this.previousGun;
    }

    public int getGunCooldownTicks() {
        return this.gunCooldownTicks;
    }

    public int getGunUseTicks() {
        return this.gunUseTicks;
    }

    public float getRecoil() {
        return this.recoil;
    }

    public float getPrevRecoil() {
        return this.prevRecoil;
    }

    public ItemStack getGunScoping() {
        return this.gunScoping;
    }

    public void serializeNBT(CompoundTag nbt) {
    }

    public void deserializeNBT(CompoundTag nbt) {
    }
}

