/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion._base.ambiance;

import bottomtextdanny.dannys_expansion._base.ambiance.AmbientWeightProvider;
import bottomtextdanny.dannys_expansion._util._client.CMC;
import bottomtextdanny.dannys_expansion.content._client.ambiances.Ambiance;
import bottomtextdanny.dannys_expansion.tables._client.Ambiences;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AmbianceManager {
    private final HashMap<Ambiance, Integer> ambianceAccessors = new HashMap();
    private Ambiance currentAmbiance = Ambiences.NONE;

    public void processTick(Level world) {
        if (this.isAmbianceUpdating(world)) {
            this.handleAmbiance();
        }
        this.currentAmbiance.tick();
    }

    public void handleAmbiance() {
        LocalPlayer player = CMC.player();
        ClientLevel world = player.f_108545_;
        if (this.ambianceAccessors.isEmpty()) {
            for (Ambiance ambiance : Ambiance.AMBIANCES) {
                this.ambianceAccessors.put(ambiance, 0);
            }
        }
        this.ambianceAccessors.replaceAll((k, v) -> 0);
        if (player.m_6084_()) {
            IntStream.range(-30, 30).parallel().forEach(x -> {
                for (int z = -30; z < 30; ++z) {
                    for (int y = -30; y < 10; ++y) {
                        BlockPos position = player.m_142538_().m_142082_(x, y, z);
                        BlockState block = world.m_8055_(position);
                        Block patt1823$temp = block.m_60734_();
                        if (!(patt1823$temp instanceof AmbientWeightProvider)) continue;
                        AmbientWeightProvider ambientBlock = (AmbientWeightProvider)patt1823$temp;
                        int old = this.ambianceAccessors.get(ambientBlock.ambiance());
                        int addition = ambientBlock.weightOnAmbiance(block, position, (Level)player.f_108545_);
                        this.ambianceAccessors.put(ambientBlock.ambiance(), Math.min(65535, old + addition));
                    }
                }
            });
        }
        boolean changed = false;
        ArrayList<Map.Entry<Ambiance, Integer>> sorted = new ArrayList<Map.Entry<Ambiance, Integer>>(this.ambianceAccessors.entrySet());
        sorted.sort(Comparator.comparingInt(Map.Entry::getValue));
        for (Map.Entry entry : sorted) {
            int weight = (Integer)entry.getValue();
            Ambiance ambiance = (Ambiance)entry.getKey();
            if (!((Ambiance)entry.getKey()).meetsConditions(player, weight)) continue;
            changed = true;
            if (this.currentAmbiance != ambiance) {
                this.currentAmbiance.setAmbianceLoopSound(null);
                ambiance.setAmbianceLoopSound(null);
            }
            this.currentAmbiance = ambiance;
            break;
        }
        if (!changed) {
            this.currentAmbiance = Ambiences.NONE;
        }
    }

    public Ambiance getCurrentAmbiance() {
        return this.currentAmbiance;
    }

    public boolean isAmbianceUpdating(Level world) {
        return world.m_46467_() % 20L == 0L;
    }

    public int getAmbianceValue(Ambiance type) {
        return this.ambianceAccessors.getOrDefault(type, 0);
    }

    public HashMap<Ambiance, Integer> getAmbientAccessors() {
        return this.ambianceAccessors;
    }
}

