/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion;

import bottomtextdanny.braincell.mod.BraincellModules;
import bottomtextdanny.braincell.mod._base.registry.managing.DeferrorType;
import bottomtextdanny.braincell.mod._base.registry.managing.ModDeferringManager;
import bottomtextdanny.braincell.mod._mod.SortedCreativeTab;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.braincell.mod.world.builtin_items.BCBoatItem;
import bottomtextdanny.dannys_expansion.DEClientSide;
import bottomtextdanny.dannys_expansion.DECommonSide;
import bottomtextdanny.dannys_expansion.DEEvaluations;
import bottomtextdanny.dannys_expansion.DEServerSide;
import bottomtextdanny.dannys_expansion._base.gameplay_hooks.AccessoryHooks;
import bottomtextdanny.dannys_expansion._base.gameplay_hooks.ConnectionHooks;
import bottomtextdanny.dannys_expansion._base.gameplay_hooks.DeathHooks;
import bottomtextdanny.dannys_expansion._base.gameplay_hooks.HurtHooks;
import bottomtextdanny.dannys_expansion._base.gameplay_hooks.MouseHooks;
import bottomtextdanny.dannys_expansion._base.gameplay_hooks.TickHooks;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.LazyRecipeType;
import bottomtextdanny.dannys_expansion._base.lazy_recipe.type.ItemStackPredicateTypes;
import bottomtextdanny.dannys_expansion._base.sensitive_hooks.CommandHooks;
import bottomtextdanny.dannys_expansion.content.items.AccessoryItem;
import bottomtextdanny.dannys_expansion.content.items.ItemDescriptionAutogen;
import bottomtextdanny.dannys_expansion.content.items.MaterialItem;
import bottomtextdanny.dannys_expansion.content.items.arrow.DEArrowItem;
import bottomtextdanny.dannys_expansion.content.items.bullet.BulletItem;
import bottomtextdanny.dannys_expansion.tables.DEAccessoryKeys;
import bottomtextdanny.dannys_expansion.tables.DEAttributes;
import bottomtextdanny.dannys_expansion.tables.DEBlockEntities;
import bottomtextdanny.dannys_expansion.tables.DEBlocks;
import bottomtextdanny.dannys_expansion.tables.DEEffects;
import bottomtextdanny.dannys_expansion.tables.DEEntities;
import bottomtextdanny.dannys_expansion.tables.DEFeatures;
import bottomtextdanny.dannys_expansion.tables.DEMenuTypes;
import bottomtextdanny.dannys_expansion.tables.DEMiniAttributes;
import bottomtextdanny.dannys_expansion.tables.DERecipes;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables.DEStructures;
import bottomtextdanny.dannys_expansion.tables._client.Ambiences;
import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import bottomtextdanny.dannys_expansion.tables.items.DEItems;
import bottomtextdanny.de_json_generator.DannyWriter;
import bottomtextdanny.de_json_generator.jsonBakers.JsonUtilsMiddleEnd;
import bottomtextdanny.de_json_generator.types.base.Generator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="dannys_expansion")
public final class DannysExpansion {
    public static final String ID = "dannys_expansion";
    public static CreativeModeTab TAB = new SortedCreativeTab("dannys_expansion"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)DEItems.ICON.get());
        }
    };
    public static final ModDeferringManager DE_REGISTRY_MANAGER = new ModDeferringManager("dannys_expansion");
    private static final DECommonSide COMMON = new DECommonSide("dannys_expansion");
    private static final DEServerSide SERVER = new DEServerSide("dannys_expansion");
    @OnlyIn(value=Dist.CLIENT)
    private static DEClientSide CLIENT;

    public DannysExpansion() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        BraincellModules.PLAYER_MODEL_HOOKS.activate();
        BraincellModules.MOUSE_HOOKS.activate();
        BraincellModules.ENTITY_HURT_CALL_OUT.activate();
        modEventBus.addListener(DannysExpansion::commonSetupPhaseHook);
        COMMON.modLoadingCallOut();
        Connection.doClientSide(() -> {
            modEventBus.addListener(DannysExpansion::clientSetupPhaseHook);
            forgeEventBus.addListener(MouseHooks::mouseSensibilityHook);
            CLIENT.modLoadingCallOut();
        });
        Connection.doServerSide(() -> {
            modEventBus.addListener(DannysExpansion::serverSetupPhaseHook);
            SERVER.modLoadingCallOut();
        });
        forgeEventBus.addListener(AccessoryHooks::onAllAccessoriesCollection);
        forgeEventBus.addListener(AccessoryHooks::onEmptyKeysCollection);
        forgeEventBus.addListener(DeathHooks::livingDeathHook);
        forgeEventBus.addListener(HurtHooks::livingHurtHook);
        forgeEventBus.addListener(ConnectionHooks::trackEntityHook);
        forgeEventBus.addListener(ConnectionHooks::playerLogInHook);
        forgeEventBus.addListener(ConnectionHooks::copyPlayerHook);
        forgeEventBus.addListener(TickHooks::serverLevelTickHook);
        forgeEventBus.addListener(TickHooks::playerTickHook);
        forgeEventBus.addListener(CommandHooks::commandRegistryHook);
        Connection.doClientSide(() -> {
            modEventBus.addListener(this::clientSetup);
            Ambiences.loadClass();
        });
        ItemStackPredicateTypes.loadClass();
        LazyRecipeType.loadClass();
        DEEvaluations.loadClass();
        DEAccessoryKeys.loadClass();
        DEStructures.loadClass();
        DEMiniAttributes.loadClass();
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.SOUND_EVENT, DESounds.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.ATTRIBUTE, DEAttributes.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.STRUCTURE, DEStructures.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.FEATURE, DEFeatures.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.BLOCK, DEBlocks.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.ITEM, DEItems.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.MANU_TYPE, DEMenuTypes.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.MOB_EFFECT, DEEffects.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.ENTITY_TYPE, DEEntities.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.BLOCK_ENTITY_TYPE, DEBlockEntities.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.PARTICLE_TYPE, DEParticles.ENTRIES);
        DE_REGISTRY_MANAGER.addRegistryDeferror(DeferrorType.RECIPE_SERIALIZER, DERecipes.ENTRIES);
        DE_REGISTRY_MANAGER.solveAndLockForeverEver();
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(ID, name);
    }

    public static void commonSetupPhaseHook(FMLCommonSetupEvent event) {
        COMMON.postModLoadingPhaseCallOut();
    }

    public static void serverSetupPhaseHook(FMLDedicatedServerSetupEvent event) {
        SERVER.postModLoadingPhaseCallOut();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetupPhaseHook(FMLClientSetupEvent event) {
        CLIENT.postModLoadingPhaseCallOut();
    }

    public static DECommonSide common() {
        return COMMON;
    }

    public static DEServerSide server() {
        return SERVER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static DEClientSide client() {
        return CLIENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        try {
            DannysExpansion.generateLang();
            DannysExpansion.generateItemList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEBlocks.registerBlockRenders();
        DEBlockEntities.registerBlockEntityRenderers();
        DEMenuTypes.registerScreens();
    }

    public static void generateItemList() throws IOException {
        File file = Generator.createJsonMain("item_list");
        JsonObject object = new JsonObject();
        HashSet<JsonObject> objectSet = new HashSet<JsonObject>(0);
        DEItems.ENTRIES.getRegistryEntries().forEach(entry -> {
            JsonObject iterationObj = new JsonObject();
            Item item = (Item)entry.get();
            String itemString = item.getRegistryName().m_135815_();
            if (item instanceof AccessoryItem) {
                iterationObj.add("type", (JsonElement)JsonUtilsMiddleEnd.cString("accessory"));
            } else if (item instanceof MaterialItem) {
                iterationObj.add("type", (JsonElement)JsonUtilsMiddleEnd.cString("material"));
            } else if (item instanceof SpawnEggItem) {
                iterationObj.add("type", (JsonElement)JsonUtilsMiddleEnd.cString("spawn_egg"));
            } else if (item instanceof BulletItem) {
                iterationObj.add("type", (JsonElement)JsonUtilsMiddleEnd.cString("bullet"));
            } else if (item instanceof DEArrowItem) {
                iterationObj.add("type", (JsonElement)JsonUtilsMiddleEnd.cString("arrow"));
            } else if (item instanceof BCBoatItem) {
                iterationObj.add("type", (JsonElement)JsonUtilsMiddleEnd.cString("boat"));
                iterationObj.add("recipe_material_id", (JsonElement)JsonUtilsMiddleEnd.cString(((Item)((BCBoatItem)item).getType().materialItem.get()).getRegistryName().toString()));
            } else {
                iterationObj.add("type", (JsonElement)JsonUtilsMiddleEnd.cString("indifferent/unused"));
            }
            iterationObj.add("name", (JsonElement)JsonUtilsMiddleEnd.cString(itemString));
            objectSet.add(iterationObj);
        });
        object.add("objects", (JsonElement)JsonUtilsMiddleEnd.cObjectCollectionRaw(objectSet));
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(JsonUtilsMiddleEnd.parse((JsonElement)object));
        writer.close();
        try {
            File drivenFile = Generator.createJsonMain("pleaseworkthistimeparttwo");
            BufferedWriter drivenWriter = new BufferedWriter(new FileWriter(drivenFile));
            drivenWriter.write(JsonUtilsMiddleEnd.parse((JsonElement)JsonUtilsMiddleEnd.cString("cock")));
            drivenWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void generateLang() throws IOException {
        File json = Generator.createLang("en_us");
        String base = Generator.getTemplateJson("/assets/", "/lang/", "handwritten");
        DannyWriter writer = new DannyWriter(new FileWriter(json));
        writer.write(base);
        writer.openBracket("");
        DESounds.ENTRIES.getRegistryEntries().forEach(soundWrap -> {
            SoundEvent sound = (SoundEvent)soundWrap.get();
            String soundLocation = sound.m_11660_().m_135815_();
            try {
                StringBuilder stringBuilder = new StringBuilder(sound.getRegistryName().m_135815_().replace('_', ' '));
                for (int i = 0; i < stringBuilder.length(); ++i) {
                    if (i != 0 && stringBuilder.charAt(i - 1) != ' ') continue;
                    stringBuilder.setCharAt(i, Character.toUpperCase(stringBuilder.charAt(i)));
                }
                writer.still("\"dannys_expansion.subtitles." + soundLocation + "\": \"" + stringBuilder + "\",");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        DEBlocks.ENTRIES.getRegistryEntries().forEach(blockWrap -> {
            Block block = (Block)blockWrap.get();
            try {
                StringBuilder stringBuilder = new StringBuilder(block.getRegistryName().m_135815_().replace('_', ' '));
                for (int i = 0; i < stringBuilder.length(); ++i) {
                    if (i != 0 && stringBuilder.charAt(i - 1) != ' ') continue;
                    stringBuilder.setCharAt(i, Character.toUpperCase(stringBuilder.charAt(i)));
                }
                writer.still("\"block.dannys_expansion." + block.getRegistryName().m_135815_() + "\": \"" + stringBuilder + "\",");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        DEAttributes.ENTRIES.getRegistryEntries().forEach(attributeWrap -> {
            Attribute attribute = (Attribute)attributeWrap.get();
            try {
                StringBuilder stringBuilder = new StringBuilder(attribute.m_22087_().replace('_', ' '));
                for (int i = 0; i < stringBuilder.length(); ++i) {
                    if (i != 0 && stringBuilder.charAt(i - 1) != ' ') continue;
                    stringBuilder.setCharAt(i, Character.toUpperCase(stringBuilder.charAt(i)));
                }
                writer.still("\"attribute.name." + attribute.m_22087_() + "\": \"" + stringBuilder + "\",");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        DEItems.ENTRIES.getRegistryEntries().forEach(objSet -> {
            Item item = (Item)objSet.get();
            try {
                StringBuilder stringBuilder = new StringBuilder(item.getRegistryName().m_135815_().replace('_', ' '));
                for (int i = 0; i < stringBuilder.length(); ++i) {
                    if (i != 0 && stringBuilder.charAt(i - 1) != ' ') continue;
                    stringBuilder.setCharAt(i, Character.toUpperCase(stringBuilder.charAt(i)));
                }
                writer.still("\"item.dannys_expansion." + item.getRegistryName().m_135815_() + "\": \"" + stringBuilder + "\",");
                if (item instanceof ItemDescriptionAutogen) {
                    ItemDescriptionAutogen descriptionGenerator = (ItemDescriptionAutogen)item;
                    writer.still("\"description.dannys_expansion." + descriptionGenerator.specifyDescriptionPath() + "." + item.getRegistryName().m_135815_() + "\": \"" + descriptionGenerator.getGenerationDescription() + "\",");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        int[] counter = new int[]{0};
        DEEntities.ENTRIES.getRegistryEntries().forEach(entityWrap -> {
            EntityType entity = (EntityType)entityWrap.get();
            try {
                StringBuilder stringBuilder = new StringBuilder(entity.getRegistryName().m_135815_().replace('_', ' '));
                for (int i = 0; i < stringBuilder.length(); ++i) {
                    if (i != 0 && stringBuilder.charAt(i - 1) != ' ') continue;
                    stringBuilder.setCharAt(i, Character.toUpperCase(stringBuilder.charAt(i)));
                }
                writer.write("\"entity.dannys_expansion." + entity.getRegistryName().m_135815_() + "\": \"" + stringBuilder + "\"");
                if (counter[0] < DEEntities.ENTRIES.getRegistryEntries().size() - 1) {
                    writer.write(44);
                }
                writer.newLine();
                counter[0] = counter[0] + 1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        writer.closeBracket("}");
        writer.close();
    }

    static {
        Connection.doClientSide(() -> {
            CLIENT = (DEClientSide)((Object)((Object)Connection.makeClientSide(() -> new DEClientSide(ID))));
        });
    }
}

