/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.util;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class InertiaUtil {
    public static final int maxRecordTick = 100;

    public static int getLeftTick(CompoundTag sword) {
        return sword.m_128451_("leftTick");
    }

    public static void setLeftTick(CompoundTag sword, int leftTick) {
        if (leftTick < 0) {
            return;
        }
        sword.m_128405_("leftTick", Math.min(leftTick, 100));
    }

    public static Vec3 getEndVec(CompoundTag tag) {
        return new Vec3(tag.m_128459_("endX"), tag.m_128459_("endY"), tag.m_128459_("endZ"));
    }

    public static void setEndVec(CompoundTag tag, Vec3 endVec) {
        tag.m_128347_("endX", endVec.f_82479_);
        tag.m_128347_("endY", endVec.f_82480_);
        tag.m_128347_("endZ", endVec.f_82481_);
    }

    public static Vec3 getViewVec(CompoundTag sword, int tickBefore) {
        if (tickBefore > 100) {
            return Vec3.f_82478_;
        }
        InertiaUtil.checkOrCreateTag(sword);
        return InertiaUtil.getQueue(sword).toArray(new Vec3[100])[100 - tickBefore];
    }

    public static void updateViewVec(CompoundTag sword, Vec3 viewVec) {
        InertiaUtil.checkOrCreateTag(sword);
        Queue<Vec3> tickValues = InertiaUtil.getQueue(sword);
        tickValues.add(viewVec);
        Vec3 old = tickValues.poll();
        ArrayDeque<Vec3> newTickValues = new ArrayDeque<Vec3>();
        for (double i = 1.0; i <= (double)tickValues.size(); i += 1.0) {
            Vec3 newVec3 = old.m_165921_(viewVec, i / (double)tickValues.size());
            newTickValues.add(newVec3);
        }
        InertiaUtil.saveQueue(sword, newTickValues);
    }

    public static Queue<Vec3> getQueue(CompoundTag sword) {
        CompoundTag tag = InertiaUtil.checkOrCreateTag(sword);
        ArrayDeque<Vec3> tickValues = new ArrayDeque<Vec3>();
        for (int i = 0; i < 100; ++i) {
            CompoundTag tickVec = tag.m_128437_("view_vec_queue", 10).m_128728_(i);
            tickValues.add(new Vec3(tickVec.m_128459_("x"), tickVec.m_128459_("y"), tickVec.m_128459_("z")));
        }
        return tickValues;
    }

    public static void saveQueue(CompoundTag sword, Queue<Vec3> tickValues) {
        CompoundTag tag = InertiaUtil.checkOrCreateTag(sword);
        for (int i = 0; i < 100; ++i) {
            CompoundTag tickVecTag = tag.m_128437_("view_vec_queue", 10).m_128728_(i);
            Vec3 tickVec = tickValues.remove();
            tickVecTag.m_128347_("x", tickVec.f_82479_);
            tickVecTag.m_128347_("y", tickVec.f_82480_);
            tickVecTag.m_128347_("z", tickVec.f_82481_);
        }
    }

    public static CompoundTag checkOrCreateTag(CompoundTag tag) {
        if (!tag.m_128441_("view_vec_queue")) {
            ListTag tickTagsList = new ListTag();
            for (int i = 0; i < 100; ++i) {
                tickTagsList.add((Object)new CompoundTag());
            }
            tag.m_128365_("view_vec_queue", (Tag)tickTagsList);
        }
        return tag;
    }
}

