/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.network.packet.server;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.epicfight.animation.ModAnimations;
import net.p1nero.ss.network.packet.BasePacket;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public record StartYakshaJumpPacket(int tick) implements BasePacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.tick);
    }

    public static StartYakshaJumpPacket decode(FriendlyByteBuf buf) {
        return new StartYakshaJumpPacket(buf.readInt());
    }

    @Override
    public void execute(@Nullable Player player) {
        if (player != null && player.m_20194_() != null) {
            player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                if (entityPatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch caster = (ServerPlayerPatch)entityPatch;
                    SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
                    if (SwordSoaring.isWOMLoaded() && !caster.hasStamina(6.0f) && !player.m_7500_()) {
                        ssPlayer.setProtectNextFall(true);
                        return;
                    }
                    ssPlayer.setProtectNextFall(true);
                    if (SwordSoaring.isWOMLoaded()) {
                        ssPlayer.isYakshaFall = true;
                    }
                    caster.playSound(EpicFightSounds.ROCKET_JUMP, 1.0f, 0.0f, 0.0f);
                    caster.playSound(EpicFightSounds.ENTITY_MOVE, 1.0f, 0.0f, 0.0f);
                    LevelUtil.circleSlamFracture(null, (Level)((ServerPlayer)caster.getOriginal()).f_19853_, (Vec3)((ServerPlayer)caster.getOriginal()).m_20182_().m_82492_(0.0, 1.0, 0.0), (double)((double)this.tick * 5.0 * 0.05), (boolean)true, (boolean)false, (boolean)false);
                    Vec3 entityEyePos = ((ServerPlayer)caster.getOriginal()).m_146892_();
                    ((HitParticleType)EpicFightParticles.AIR_BURST.get()).spawnParticleWithArgument(((ServerPlayer)caster.getOriginal()).m_183503_(), entityEyePos.f_82479_, entityEyePos.f_82480_, entityEyePos.f_82481_, 0.0, 0.0, 2.0 + 0.05 * (double)this.tick);
                    if (SwordSoaring.isWOMLoaded()) {
                        if (!player.m_7500_()) {
                            caster.consumeStamina(6.0f);
                        }
                        caster.playAnimationSynchronized(ModAnimations.AGONY_PLUNGE_FORWARD, 0.0f);
                    } else {
                        caster.consumeStamina(2.0f);
                        caster.playAnimationSynchronized(Animations.BIPED_DEMOLITION_LEAP, 0.0f);
                    }
                }
            });
        }
    }
}

