/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.network.packet.server;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.epicfight.animation.ModAnimations;
import net.p1nero.ss.epicfight.skill.ModSkills;
import net.p1nero.ss.epicfight.skill.StellarRestoration;
import net.p1nero.ss.network.packet.BasePacket;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public record StartStellarRestorationPacket(boolean end) implements BasePacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.end);
    }

    public static StartStellarRestorationPacket decode(FriendlyByteBuf buf) {
        return new StartStellarRestorationPacket(buf.readBoolean());
    }

    @Override
    public void execute(@Nullable Player player) {
        if (player != null && player.m_20194_() != null) {
            player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                if (entityPatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch caster = (ServerPlayerPatch)entityPatch;
                    if (!caster.hasStamina(5.0f)) {
                        return;
                    }
                    if (!caster.getSkill(ModSkills.STELLAR_RESTORATION).isEmpty()) {
                        SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
                        if (this.end) {
                            Entity sword = player.f_19853_.m_6815_(ssPlayer.stellarSwordID);
                            if (sword != null) {
                                player.m_6021_(sword.m_20185_(), sword.m_20186_(), sword.m_20189_());
                                sword.m_146870_();
                                caster.playAnimationSynchronized(Animations.SWEEPING_EDGE, 0.0f);
                                ssPlayer.stayInAirTick = 20;
                            }
                        } else if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            if (caster.hasStamina(4.0f)) {
                                if (!player.m_7500_()) {
                                    caster.consumeStamina(5.0f);
                                }
                                StellarRestoration.summonSword(serverPlayer, ssPlayer);
                                caster.playAnimationSynchronized(ModAnimations.STELLAR_RESTORATION_PRE, 0.0f);
                                ssPlayer.isStellarRestorationPressing = true;
                                ssPlayer.setProtectNextFall(true);
                            }
                        }
                    }
                }
            });
        }
    }
}

