/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.network.packet.server;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.p1nero.ss.Config;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.epicfight.animation.ModAnimations;
import net.p1nero.ss.epicfight.skill.SwordSoaringSkill;
import net.p1nero.ss.network.packet.BasePacket;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public record StartFlyPacket(float flySpeedLevel) implements BasePacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.flySpeedLevel);
    }

    public static StartFlyPacket decode(FriendlyByteBuf buf) {
        return new StartFlyPacket(buf.readFloat());
    }

    @Override
    public void execute(@Nullable Player player) {
        SwordSoaringSkill.flySpeedLevel = this.flySpeedLevel;
        if (player != null && player.m_20194_() != null) {
            player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                ssPlayer.setFlying(true);
                player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                    if (entityPatch instanceof ServerPlayerPatch) {
                        ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                        if (((Boolean)Config.FORCE_FLY_ANIM.get()).booleanValue() || !serverPlayerPatch.getEntityState().inaction() && !ssPlayer.isPlayingAnim) {
                            if (this.flySpeedLevel == 1.0f) {
                                serverPlayerPatch.playAnimationSynchronized(ModAnimations.FLY_ON_SWORD_ADVANCED, 0.15f);
                            } else {
                                serverPlayerPatch.playAnimationSynchronized(ModAnimations.FLY_ON_SWORD_BASIC, 0.15f);
                            }
                        }
                    }
                });
            });
        }
    }
}

