/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.epicfight.skill;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.p1nero.ss.Config;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.client.SetClientYakshaMaskTimePacket;
import net.p1nero.ss.network.packet.server.StartYakshaJumpPacket;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class YakshaMask
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac114517");
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation>> slamMotions;
    private final StaticAnimation defaultAnim = Animations.METEOR_SLAM;
    public static final int height = 5;
    public static final float forcedXRot = 89.9f;

    public static Builder createYakshaMaskBuilder() {
        return new Builder().setCategory((SkillCategory)SkillCategories.IDENTITY).setResource(Skill.Resource.NONE).addSlamMotion((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR, (item, player) -> Animations.METEOR_SLAM).addSlamMotion((WeaponCategory)CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.METEOR_SLAM).addSlamMotion((WeaponCategory)CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.METEOR_SLAM).addSlamMotion((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.METEOR_SLAM);
    }

    public YakshaMask(Builder builder) {
        super((Skill.Builder)builder);
        this.slamMotions = builder.slamMotions;
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)event.getPlayerPatch();
            Player player = (Player)localPlayerPatch.getOriginal();
            boolean jumpPressed = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
            player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                if (!jumpPressed || player.m_20202_() != null || player.m_150110_().f_35935_ || !localPlayerPatch.isBattleMode() || ssPlayer.getYakshaMaskTimer() == 0 || !ssPlayer.canYakshaMask) {
                    return;
                }
                ssPlayer.canYakshaMask = false;
                int height = 5;
                PacketRelay.sendToServer(PacketHandler.INSTANCE, new StartYakshaJumpPacket(height));
                if (SwordSoaring.isWOMLoaded()) {
                    return;
                }
                int modifiedTicks = (int)((double)7.4668f * Math.log10((float)height + 1.0f) / Math.log10(2.0));
                Vec3f jumpDirection = new Vec3f(0.0f, (float)modifiedTicks * 0.05f, 0.0f);
                float xRot = Mth.m_14036_((float)(70.0f + Mth.m_14036_((float)-60.0f, (float)-90.0f, (float)0.0f)), (float)0.0f, (float)70.0f);
                jumpDirection.add(0.0f, xRot / 70.0f * 0.05f, 0.0f);
                jumpDirection.rotate(xRot, Vec3f.X_AXIS);
                jumpDirection.rotate(-localPlayerPatch.getCameraYRot(), Vec3f.Y_AXIS);
                ((LocalPlayer)localPlayerPatch.getOriginal()).m_20256_(jumpDirection.toDoubleVector());
            });
        });
        listener.addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
            Skill skill = event.getSkillContainer().getSkill();
            Player player = (Player)event.getPlayerPatch().getOriginal();
            player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                StaticAnimation slamAnimation;
                if (ssPlayer.yakshaMaskCooldownTimer == 0 && skill.getCategory() == SkillCategories.WEAPON_INNATE && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ssPlayer.setYakshaMaskTimer(500);
                    ssPlayer.yakshaMaskCooldownTimer = ((Double)Config.YAKSHAS_MASK_COOLDOWN.get()).intValue();
                    PacketRelay.sendToPlayer(PacketHandler.INSTANCE, new SetClientYakshaMaskTimePacket(), serverPlayer);
                    player.f_19853_.m_5594_(null, player.m_20097_(), SoundEvents.f_11860_, SoundSource.BLOCKS, 0.3f, 1.0f);
                }
                if (SwordSoaring.isWOMLoaded()) {
                    return;
                }
                if (skill.getCategory() != SkillCategories.BASIC_ATTACK && skill.getCategory() != SkillCategories.AIR_ATTACK) {
                    return;
                }
                if (player.m_20096_() || ssPlayer.canYakshaMask) {
                    return;
                }
                if (!event.getPlayerPatch().hasStamina(1.5f)) {
                    return;
                }
                CapabilityItem holdingItem = container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND);
                if (!this.slamMotions.containsKey(holdingItem.getWeaponCategory())) {
                    slamAnimation = this.defaultAnim;
                } else {
                    slamAnimation = this.slamMotions.get(holdingItem.getWeaponCategory()).apply(holdingItem, container.getExecuter());
                    if (slamAnimation == null) {
                        slamAnimation = this.defaultAnim;
                    }
                }
                Vec3 vec3 = player.m_20299_(1.0f);
                Vec3 vec31 = player.m_20252_(1.0f);
                Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * 50.0, vec31.f_82480_ * 50.0, vec31.f_82481_ * 50.0);
                BlockHitResult hitResult = player.f_19853_.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, container.getExecuter().getOriginal()));
                if (hitResult.m_6662_() != HitResult.Type.MISS) {
                    event.getPlayerPatch().consumeStamina(3.0f);
                    Vec3 to = hitResult.m_82450_();
                    Vec3 from = player.m_20182_();
                    double distance = to.m_82554_(from);
                    if (distance > 4.0) {
                        ssPlayer.isYakshaFall = true;
                        container.getExecuter().playAnimationSynchronized(slamAnimation, 0.0f);
                        event.setCanceled(true);
                    }
                } else {
                    player.m_146926_(89.9f);
                    vec31 = player.m_20252_(1.0f);
                    vec32 = vec3.m_82520_(vec31.f_82479_ * 50.0, vec31.f_82480_ * 50.0, vec31.f_82481_ * 50.0);
                    hitResult = player.f_19853_.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, container.getExecuter().getOriginal()));
                    if (hitResult.m_6662_() != HitResult.Type.MISS) {
                        event.getPlayerPatch().consumeStamina(3.0f);
                        Vec3 to = hitResult.m_82450_();
                        Vec3 from = player.m_20182_();
                        double distance = to.m_82554_(from);
                        if (distance > 4.0) {
                            ssPlayer.isYakshaFall = true;
                            container.getExecuter().playAnimationSynchronized(slamAnimation, 0.0f);
                            event.setCanceled(true);
                        }
                    }
                }
            });
        });
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
            if (((DamageSource)event.getDamageSource()).m_146707_() && ssPlayer.isProtectNextFall()) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                ssPlayer.setProtectNextFall(false);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> {
            Player player = (Player)event.getPlayerPatch().getOriginal();
            player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                if (ssPlayer.isYakshaFall) {
                    ssPlayer.isYakshaFall = false;
                    LevelUtil.circleSlamFracture(null, (Level)player.f_19853_, (Vec3)player.m_20182_().m_82492_(0.0, 1.0, 0.0), (double)2.5, (boolean)false, (boolean)false, (boolean)true);
                }
            });
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            int yakshaMaskTimer;
            if (ssPlayer.yakshaMaskCooldownTimer > 0) {
                --ssPlayer.yakshaMaskCooldownTimer;
            }
            if ((yakshaMaskTimer = ssPlayer.getYakshaMaskTimer()) > 0) {
                ssPlayer.setYakshaMaskTimer(yakshaMaskTimer - 1);
                player.f_19853_.m_7106_((ParticleOptions)EpicFightParticles.BOSS_CASTING.get(), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 0.0, 0.2, 0.0);
            }
            if (event.player.m_20096_()) {
                ssPlayer.canYakshaMask = true;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        AtomicBoolean toReturn = new AtomicBoolean(false);
        ((Player)container.getExecuter().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> toReturn.set(ssPlayer.yakshaMaskCooldownTimer > 0));
        return toReturn.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        Player player = (Player)container.getExecuter().getOriginal();
        SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        GuiComponent.m_93236_((PoseStack)poseStack, (Font)gui.font, (String)String.format("%d", ssPlayer.yakshaMaskCooldownTimer / 40), (int)((int)(x + 4.0f)), (int)((int)(y + 6.0f)), (int)0xFFFFFF);
    }

    public static class Builder
    extends Skill.Builder<YakshaMask> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation>> slamMotions = Maps.newHashMap();

        public Builder addSlamMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation> function) {
            this.slamMotions.put(weaponCategory, function);
            return this;
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

