/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.epicfight.skill;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.p1nero.ss.Config;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.enchantment.ModEnchantments;
import net.p1nero.ss.epicfight.skill.ModSkills;
import net.p1nero.ss.keymapping.ModKeyMappings;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.server.StartFlyPacket;
import net.p1nero.ss.network.packet.server.StopFlyPacket;
import net.p1nero.ss.util.InertiaUtil;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SwordSoaringSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac114514");
    private static final SkillDataManager.SkillDataKey<Integer> COOL_DOWN_TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static float flySpeedLevel = 1.0f;

    public SwordSoaringSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        return false;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(COOL_DOWN_TIMER);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> ((Player)event.getPlayerPatch().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            if (((Boolean)Config.FORCE_FLY_ANIM.get()).booleanValue() && ssPlayer.isFlying() && !event.getSkillContainer().hasSkill(ModSkills.SWORD_SOARING)) {
                event.setCanceled(true);
            }
        }));
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_146707_()) {
                Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                    if (ssPlayer.isProtectNextFall()) {
                        ssPlayer.setProtectNextFall(false);
                    }
                });
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> {
            Player player = (Player)event.getPlayerPatch().getOriginal();
            player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                if (ssPlayer.flyHeight == -1.0 || ssPlayer.flyHeight > (double)event.getForgeEvent().getDistance()) {
                    return;
                }
                event.getForgeEvent().setDistance((float)((int)ssPlayer.flyHeight));
                ssPlayer.flyHeight = -1.0;
            });
        });
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecuter().isLogicalClient()) {
            Player player = (Player)container.getExecuter().getOriginal();
            ItemStack sword = player.m_21205_();
            player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                int currentCoolDown = (Integer)container.getDataManager().getDataValue(COOL_DOWN_TIMER);
                if (currentCoolDown > 0) {
                    container.getDataManager().setData(COOL_DOWN_TIMER, (Object)(currentCoolDown - 1));
                    return;
                }
                boolean fly = ModKeyMappings.FLY.m_90857_();
                if (ModKeyMappings.FLY.isRelease()) {
                    container.getDataManager().setData(COOL_DOWN_TIMER, (Object)((Double)Config.SWORD_SOARING_COOLDOWN.get()).intValue());
                }
                if (!fly || ((Player)container.getExecuter().getOriginal()).m_20202_() != null || ((Player)container.getExecuter().getOriginal()).m_150110_().f_35935_ || !container.getExecuter().isBattleMode() || container.getExecuter().getStamina() <= 0.1f || player.m_20077_() || player.m_5842_() || !SwordSoaring.isValidSword(sword) && !ssPlayer.hasSwordEntity()) {
                    PacketRelay.sendToServer(PacketHandler.INSTANCE, new StopFlyPacket());
                    if (((Boolean)Config.ENABLE_INERTIA.get()).booleanValue() && ssPlayer.isFlying()) {
                        Vec3 endVec = InertiaUtil.getViewVec(player.getPersistentData(), 1).m_82490_((Double)Config.FLY_SPEED_SCALE.get() * (double)flySpeedLevel);
                        InertiaUtil.setEndVec(player.getPersistentData(), endVec);
                        double leftTick = endVec.m_82553_() * 100.0;
                        InertiaUtil.setLeftTick(player.getPersistentData(), (int)leftTick);
                    }
                    ssPlayer.setFlying(false);
                    ssPlayer.setAnticipationTick(0);
                    return;
                }
                if (ssPlayer.getAnticipationTick() == 0) {
                    ssPlayer.setAnticipationTick(((Double)Config.MAX_ANTICIPATION_TICK.get()).intValue());
                    return;
                }
                if (ssPlayer.getAnticipationTick() > 1) {
                    ssPlayer.setAnticipationTick(ssPlayer.getAnticipationTick() - 1);
                    return;
                }
                PacketRelay.sendToServer(PacketHandler.INSTANCE, new StartFlyPacket(flySpeedLevel));
                ssPlayer.setFlying(true);
            });
        }
    }

    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue(COOL_DOWN_TIMER) > 0;
    }

    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        gui.font.m_92750_(poseStack, String.format("%.1f", (double)((Integer)container.getDataManager().getDataValue(COOL_DOWN_TIMER)).intValue() / 20.0), x, y + 6.0f, 0xFFFFFF);
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            if (ssPlayer.isFlying()) {
                if (player.m_7578_() && ModKeyMappings.CHANGE_SPEED.isRelease()) {
                    flySpeedLevel = ModKeyMappings.CHANGE_SPEED.isEvenNumber() ? 2.0f : 1.0f;
                    player.m_5661_(Component.m_130674_((String)(I18n.m_118938_((String)"tip.sword_soaring.speed_level", (Object[])new Object[0]) + (int)flySpeedLevel)), true);
                }
                if (((Boolean)Config.ENABLE_INERTIA.get()).booleanValue()) {
                    Vec3 targetVec = InertiaUtil.getViewVec(player.getPersistentData(), ((Double)Config.INERTIA_TICK_BEFORE.get()).intValue()).m_82490_((Double)Config.FLY_SPEED_SCALE.get() * (double)flySpeedLevel);
                    if (targetVec.m_82553_() != 0.0) {
                        player.m_20256_(targetVec);
                    }
                } else {
                    player.m_20256_(player.m_20252_(0.5f).m_82490_((Double)Config.FLY_SPEED_SCALE.get() * (double)flySpeedLevel));
                }
                SwordSoaringSkill.resetHeight(player, ssPlayer);
                player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                    if (entityPatch instanceof ServerPlayerPatch) {
                        ServerPlayerPatch playerPatch = (ServerPlayerPatch)entityPatch;
                        if (!player.m_7500_()) {
                            int enchantmentLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.SWORD_SOARING.get()), (LivingEntity)player);
                            float scale = switch (enchantmentLevel) {
                                case 1 -> 0.75f;
                                case 2 -> 0.5f;
                                default -> 1.0f;
                            };
                            playerPatch.consumeStamina(((Double)Config.STAMINA_CONSUME_PER_TICK.get()).floatValue() * scale * flySpeedLevel);
                        }
                    }
                });
            } else if (((Boolean)Config.ENABLE_INERTIA.get()).booleanValue()) {
                double endVecLength = InertiaUtil.getEndVec(player.getPersistentData()).m_82553_();
                if (InertiaUtil.getLeftTick(player.getPersistentData()) > 0 && endVecLength != 0.0) {
                    SwordSoaringSkill.resetHeight(player, ssPlayer);
                    int leftTick = InertiaUtil.getLeftTick(player.getPersistentData());
                    InertiaUtil.setLeftTick(player.getPersistentData(), leftTick - 1);
                    double max = endVecLength * 100.0;
                    player.m_20256_(InertiaUtil.getEndVec(player.getPersistentData()).m_165921_(Vec3.f_82478_, (max - (double)leftTick) / max));
                }
            }
        });
        InertiaUtil.updateViewVec(player.getPersistentData(), player.m_20252_(0.0f));
    }

    private static void resetHeight(Player player, SSPlayer ssPlayer) {
        Vec3 to;
        Vec3 from = player.m_20299_(1.0f);
        BlockHitResult hitResult = player.f_19853_.m_45547_(new ClipContext(from, to = from.m_82520_(0.0, -500.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
        ssPlayer.flyHeight = hitResult.m_6662_() != HitResult.Type.MISS ? hitResult.m_82448_((Entity)player) : -1.0;
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }
}

