/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.epicfight.skill;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.p1nero.ss.Config;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.entity.StellarSwordEntity;
import net.p1nero.ss.epicfight.animation.ModAnimations;
import net.p1nero.ss.epicfight.skill.ModSkills;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.server.StartStellarRestorationPacket;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class StellarRestoration
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac114518");

    public StellarRestoration(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_146707_()) {
                Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                    if (ssPlayer.isProtectNextFall()) {
                        event.setAmount(0.0f);
                        event.setCanceled(true);
                        ssPlayer.setProtectNextFall(false);
                    }
                });
            }
        });
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            if (ssPlayer.stellarRestorationCooldownTimer > 0) {
                --ssPlayer.stellarRestorationCooldownTimer;
            }
            if (ssPlayer.stayInAirTick > 0) {
                player.m_20256_(player.m_20184_().m_82490_(0.01));
                --ssPlayer.stayInAirTick;
            }
            if (!player.m_7578_()) {
                return;
            }
            player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                if (entityPatch instanceof LocalPlayerPatch) {
                    LocalPlayerPatch caster = (LocalPlayerPatch)entityPatch;
                    if (caster.getSkill(ModSkills.STELLAR_RESTORATION) == null || ssPlayer.stellarRestorationCooldownTimer > 0 || !SwordSoaring.isValidSword(player.m_21205_())) {
                        return;
                    }
                    boolean isDodgeKeyPress = EpicFightKeyMappings.DODGE.m_90857_();
                    if (isDodgeKeyPress && !ssPlayer.isStellarRestorationSecondPressing) {
                        caster.playAnimationSynchronized(ModAnimations.STELLAR_RESTORATION_PRE0, 0.0f);
                        player.m_5618_(player.m_6080_());
                        player.m_20256_(Vec3.f_82478_);
                    }
                    if (isDodgeKeyPress) {
                        ssPlayer.isStellarRestorationPressing = true;
                        return;
                    }
                    if (ssPlayer.isStellarRestorationPressing) {
                        if (ssPlayer.isStellarRestorationSecondPressing) {
                            ssPlayer.isStellarRestorationPressing = false;
                            ssPlayer.isStellarRestorationSecondPressing = false;
                            ssPlayer.stellarRestorationCooldownTimer = ((Double)Config.STELLAR_RESTORATION_COOLDOWN.get()).intValue();
                            player.f_19853_.m_7106_((ParticleOptions)EpicFightParticles.ENTITY_AFTER_IMAGE.get(), player.m_20185_(), player.m_20186_(), player.m_20189_(), Double.longBitsToDouble(player.m_142049_()), 0.0, 0.0);
                            PacketRelay.sendToServer(PacketHandler.INSTANCE, new StartStellarRestorationPacket(true));
                            ssPlayer.stayInAirTick = 20;
                            return;
                        }
                        PacketRelay.sendToServer(PacketHandler.INSTANCE, new StartStellarRestorationPacket(false));
                        caster.getSkill(ModSkills.STELLAR_RESTORATION).sendExecuteRequest(caster, ClientEngine.getInstance().controllEngine);
                        ssPlayer.isStellarRestorationPressing = false;
                        ssPlayer.isStellarRestorationSecondPressing = true;
                    }
                }
            });
        });
    }

    public static void summonSword(ServerPlayer player, SSPlayer ssPlayer) {
        if (!SwordSoaring.isValidSword(player.m_21205_())) {
            return;
        }
        StellarSwordEntity sword = new StellarSwordEntity(player.m_21205_(), player.f_19853_);
        ssPlayer.stellarSwordID = sword.m_142049_();
        sword.m_5602_((Entity)player);
        sword.m_20242_(true);
        sword.m_36781_(0.01);
        sword.m_20225_(false);
        sword.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        sword.m_36735_(0);
        sword.m_36767_((byte)5);
        sword.m_146884_(player.m_20299_(1.0f).m_82520_(0.0, 1.0, 0.0));
        Vec3 view = player.m_20252_(1.0f);
        sword.m_6686_(view.f_82479_, view.f_82480_, view.f_82481_, 3.0f, 0.0f);
        player.f_19853_.m_5594_(null, sword.m_20097_(), EpicFightSounds.ENTITY_MOVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_183503_().m_7967_((Entity)sword);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        AtomicBoolean toReturn = new AtomicBoolean(false);
        ((Player)container.getExecuter().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> toReturn.set(ssPlayer.stellarRestorationCooldownTimer > 0));
        return toReturn.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        Player player = (Player)container.getExecuter().getOriginal();
        SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        GuiComponent.m_93236_((PoseStack)poseStack, (Font)gui.font, (String)String.format("%.1f", (double)ssPlayer.stellarRestorationCooldownTimer / 40.0), (int)((int)(x + 4.0f)), (int)((int)(y + 6.0f)), (int)0xFFFFFF);
    }
}

