/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.epicfight.skill;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.entity.ModEntities;
import net.p1nero.ss.entity.RainScreenSwordEntity;
import net.p1nero.ss.epicfight.animation.ModAnimations;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.client.AddBladeRushSkillParticlePacket;
import net.p1nero.ss.network.packet.client.SyncSwordOwnerPacket;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RainScreen
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac114515");

    public RainScreen(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            ServerPlayerPatch caster = (ServerPlayerPatch)event.getPlayerPatch();
            if (caster.hasStamina(10.0f)) {
                ServerPlayer player = (ServerPlayer)caster.getOriginal();
                SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
                if (!SwordSoaring.isValidSword(player.m_21205_()) || caster.getEntityState().inaction() || !ssPlayer.getSwordScreensID().isEmpty() || !caster.isBattleMode() || ssPlayer.rainScreenCooldownTimer > 0) {
                    return;
                }
                caster.playAnimationSynchronized(ModAnimations.RAIN_SCREEN, 0.0f);
                double r = 2.0;
                List entities = player.m_183503_().m_45933_((Entity)player, new AABB(player.m_20318_(0.0f).m_82520_(-r, -r, -r), player.m_20318_(0.0f).m_82520_(r, r, r)));
                for (Entity entity : entities) {
                    if (entity.m_142049_() == player.m_142049_()) continue;
                    entity.m_6469_(DamageSource.m_19344_((Player)player), 2.0f);
                    Vec3 targetLocation = entity.m_20318_(1.0f);
                    Vec3 viewVector = player.m_20252_(1.0f);
                    viewVector = viewVector.m_82492_(0.0, viewVector.f_82480_, 0.0).m_82541_();
                    Vec3 toSourceLocation = targetLocation.m_82546_(((ServerPlayer)caster.getOriginal()).m_20182_()).m_82541_();
                    if (!(toSourceLocation.m_82526_(viewVector) > 0.0)) continue;
                    PacketRelay.sendToPlayer(PacketHandler.INSTANCE, new AddBladeRushSkillParticlePacket(targetLocation, Vec3.f_82478_), player);
                    player.f_19853_.m_5594_(null, entity.m_20097_(), EpicFightSounds.BLADE_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            DamageSource damageSource = (DamageSource)event.getDamageSource();
            float knockback = 0.25f;
            SSPlayer ssPlayer = (SSPlayer)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
            ServerPlayer serverPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            if (!(ssPlayer.getSwordScreenEntityCount() <= 0 || ssPlayer.isProtectNextFall() && damageSource.m_146707_())) {
                Set<Integer> swordID = ssPlayer.getSwordScreensID();
                for (int i : swordID) {
                    Entity sword = serverPlayer.m_183503_().m_6815_(i);
                    if (sword == null) continue;
                    ((ServerPlayerPatch)event.getPlayerPatch()).consumeStaminaAlways(3.0f);
                    serverPlayer.m_5634_(2.0f);
                    ssPlayer.setSwordScreenEntityCount(ssPlayer.getSwordScreenEntityCount() - 1);
                    sword.m_146870_();
                    swordID.remove(i);
                    ssPlayer.setSwordID(swordID);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                    break;
                }
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.CLASH, -0.05f, 0.1f);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument(serverPlayer.m_183503_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serverPlayer, damageSource.m_7640_());
                Entity patt6584$temp = damageSource.m_7640_();
                if (patt6584$temp instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)patt6584$temp;
                    ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)livingEntity) * 0.1f);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, EVENT_UUID, event -> {
            if (event.getSkill() instanceof RainScreen && !((Player)container.getExecuter().getOriginal()).m_7500_() && container.getStack() > 0) {
                if (event.shouldConsume()) {
                    this.setStackSynchronize((ServerPlayerPatch)container.getExecuter(), container.getStack() - 1);
                }
                event.setResourceType(Skill.Resource.NONE);
            }
        });
    }

    public static void summonSword(ServerPlayer player) {
        player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            Set<Integer> swordID = ssPlayer.getSwordScreensID();
            for (int i = 0; i < 4; ++i) {
                RainScreenSwordEntity sword = (RainScreenSwordEntity)((EntityType)ModEntities.RAIN_SCREEN_SWORD.get()).m_20592_(player.m_183503_(), null, null, player.m_20097_(), MobSpawnType.MOB_SUMMONED, true, true);
                if (sword == null) {
                    return;
                }
                sword.setRider((Player)player);
                sword.setItemStack(player.m_21205_());
                PacketRelay.sendToAll(PacketHandler.INSTANCE, new SyncSwordOwnerPacket(player.m_142049_(), sword.m_142049_()));
                sword.setSwordID(i);
                sword.m_146884_(player.m_20182_());
                ssPlayer.setSwordScreenEntityCount(ssPlayer.getSwordScreenEntityCount() + 1);
                swordID.add(sword.m_142049_());
            }
        });
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        event.player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            if (ssPlayer.rainScreenCooldownTimer > 0) {
                --ssPlayer.rainScreenCooldownTimer;
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        AtomicBoolean toReturn = new AtomicBoolean(false);
        ((Player)container.getExecuter().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> toReturn.set(ssPlayer.rainScreenCooldownTimer > 0));
        return toReturn.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        Player player = (Player)container.getExecuter().getOriginal();
        SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        GuiComponent.m_93236_((PoseStack)poseStack, (Font)gui.font, (String)String.format("%d", ssPlayer.rainScreenCooldownTimer / 40), (int)((int)(x + 4.0f)), (int)((int)(y + 6.0f)), (int)0xFFFFFF);
    }
}

