/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.epicfight.skill;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.p1nero.ss.Config;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.entity.RainCutterSwordEntity;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RainCutter
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac114516");

    public RainCutter(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
            Skill skill = event.getSkillContainer().getSkill();
            Player player = (Player)event.getPlayerPatch().getOriginal();
            player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                if (skill.getCategory() == SkillCategories.WEAPON_INNATE && ssPlayer.rainCutterCooldownTimer == 0) {
                    ssPlayer.setRainCutterTimer(400);
                    ssPlayer.rainCutterCooldownTimer = ((Double)Config.RAIN_CUTTER_COOLDOWN.get()).intValue();
                    ssPlayer.setScreenCutterCoolDown(false);
                } else if (!(skill.getCategory() != SkillCategories.BASIC_ATTACK && skill.getCategory() != SkillCategories.AIR_ATTACK || ssPlayer.getRainCutterTimer() <= 0 || ssPlayer.isScreenCutterCoolDown())) {
                    ssPlayer.setScreenCutterCoolDown(true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        this.summonSword(serverPlayer);
                    }
                }
            });
        });
    }

    public void summonSword(ServerPlayer player) {
        if (!SwordSoaring.isValidSword(player.m_21205_())) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            RainCutterSwordEntity sword = new RainCutterSwordEntity(player.m_21205_(), player.f_19853_, i);
            sword.m_5602_((Entity)player);
            sword.m_20242_(true);
            sword.m_36781_(0.01);
            sword.m_20225_(true);
            sword.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            sword.m_36735_(1);
            sword.m_36767_((byte)5);
            sword.m_146884_(player.m_20318_(1.0f).m_82549_(sword.getOffset()));
            sword.initDirection();
            player.f_19853_.m_5594_(null, sword.m_20097_(), EpicFightSounds.ENTITY_MOVE, SoundSource.BLOCKS, 0.3f, 1.0f);
            player.m_183503_().m_7967_((Entity)sword);
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        event.player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            int rainCutterTimer = ssPlayer.getRainCutterTimer();
            if (rainCutterTimer > 0) {
                ssPlayer.setRainCutterTimer(rainCutterTimer - 1);
            }
            if (ssPlayer.rainCutterCooldownTimer > 0) {
                --ssPlayer.rainCutterCooldownTimer;
            }
            if (rainCutterTimer % 40 == 0 && rainCutterTimer != 0) {
                ssPlayer.setScreenCutterCoolDown(false);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        AtomicBoolean toReturn = new AtomicBoolean(false);
        ((Player)container.getExecuter().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> toReturn.set(ssPlayer.rainCutterCooldownTimer > 0));
        return toReturn.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        Player player = (Player)container.getExecuter().getOriginal();
        SSPlayer ssPlayer = (SSPlayer)player.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        GuiComponent.m_93236_((PoseStack)poseStack, (Font)gui.font, (String)String.format("%d", ssPlayer.rainCutterCooldownTimer / 40), (int)((int)(x + 4.0f)), (int)((int)(y + 6.0f)), (int)0xFFFFFF);
    }
}

