/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.epicfight.animation;

import java.util.Set;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.p1nero.ss.Config;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.epicfight.skill.RainScreen;
import reascer.wom.animation.attacks.SpecialAttackAnimation;
import reascer.wom.gameasset.WOMColliders;
import reascer.wom.world.damagesources.WOMExtraDamageInstance;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="sword_soaring", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModAnimations {
    public static StaticAnimation PLUNGING_ATTACK;
    public static StaticAnimation JUMP_TO_SWORD;
    public static StaticAnimation FLY_ON_SWORD;
    public static StaticAnimation FLY_ON_SWORD_BASIC;
    public static StaticAnimation FLY_ON_SWORD_ADVANCED;
    public static StaticAnimation RAIN_SCREEN;
    public static StaticAnimation STELLAR_RESTORATION_PRE;
    public static StaticAnimation STELLAR_RESTORATION_PRE0;
    public static StaticAnimation AGONY_PLUNGE_FORWARD;

    @SubscribeEvent
    public static void registerAnimations(AnimationRegistryEvent event) {
        event.getRegistryMap().put("sword_soaring", ModAnimations::build);
    }

    private static void build() {
        HumanoidArmature biped = Armatures.BIPED;
        RAIN_SCREEN = new ActionAnimation(0.05f, 0.7f, "biped/rain_screen", (Armature)biped).addStateRemoveOld(EntityState.MOVEMENT_LOCKED, (Object)false).newTimePair(0.0f, 2.0f).addStateRemoveOld(EntityState.INACTION, (Object)true).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {
            if (entitypatch instanceof LocalPlayerPatch) {
                LocalPlayerPatch playerPatch = (LocalPlayerPatch)entitypatch;
                ((LocalPlayer)playerPatch.getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                    ssPlayer.rainScreenCooldownTimer = ((Double)Config.RAIN_SCREEN_COOLDOWN.get()).intValue();
                });
            }
            Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            entitypatch.playSound(EpicFightSounds.ROLL, 0.0f, 0.0f);
            ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_7107_((ParticleOptions)EpicFightParticles.AIR_BURST.get(), pos.f_82479_, pos.f_82480_ + (double)((LivingEntity)entitypatch.getOriginal()).m_20206_() * 0.5, pos.f_82481_, 0.0, -1.0, 2.0);
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch caster = (ServerPlayerPatch)entitypatch;
                RainScreen.summonSword((ServerPlayer)caster.getOriginal());
                ((ServerPlayer)caster.getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                    ssPlayer.rainScreenCooldownTimer = ((Double)Config.RAIN_SCREEN_COOLDOWN.get()).intValue();
                });
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        STELLAR_RESTORATION_PRE0 = new StaticAnimation(true, "biped/stellar_restoration_pre0", (Armature)biped).addStateRemoveOld(EntityState.MOVEMENT_LOCKED, (Object)true).addStateRemoveOld(EntityState.INACTION, (Object)true);
        STELLAR_RESTORATION_PRE = new ActionAnimation(0.05f, 2.0f, "biped/stellar_restoration_pre", (Armature)biped).addStateRemoveOld(EntityState.MOVEMENT_LOCKED, (Object)true).newTimePair(0.0f, 2.0f).addStateRemoveOld(EntityState.INACTION, (Object)true).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> entitypatch.playSound(EpicFightSounds.ROLL, 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {
            if (entitypatch instanceof PlayerPatch) {
                PlayerPatch playerpatch = (PlayerPatch)entitypatch;
                playerpatch.changeModelYRot(0.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
        if (ModList.get().isLoaded("wom")) {
            AGONY_PLUNGE_FORWARD = new SpecialAttackAnimation(0.05f, "biped/agony_plunge_forward", (Armature)biped, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, 0.1f, 0.2f, 0.25f, 0.25f, biped.rootJoint, (Collider)new OBBCollider(5.0, 2.0, 5.0, 0.0, 0.0, 0.0)), new AttackAnimation.Phase(0.25f, 1.1f, 1.45f, 1.7f, Float.MAX_VALUE, biped.rootJoint, WOMColliders.AGONY_PLUNGE)}).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)EpicFightSounds.WHOOSH_BIG, 0).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT, 0).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)10.0f), 0).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)9.0f), 0).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.setter((float)1.0f), 0).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 0).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.2f), 1).addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(WOMExtraDamageInstance.WOM_SWEEPING_EDGE_ENCHANTMENT.create(new float[]{1.5f}), WOMExtraDamageInstance.TARGET_LOST_HEALTH.create(new float[]{0.2f})), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.0f), 1).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)10.0f), 1).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(SourceTags.WEAPON_INNATE), 1).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)EpicFightSounds.BLADE_RUSH_FINISHER, 1).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.BLADE_RUSH_SKILL, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.KNOCKDOWN, 1).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.5f)).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.0f, 1.3f}));
        }
        JUMP_TO_SWORD = new ActionAnimation(0.15f, 2.0f, "biped/jump_to_sword", (Armature)biped).addStateRemoveOld(EntityState.MOVEMENT_LOCKED, (Object)true).newTimePair(0.0f, 2.0f).addStateRemoveOld(EntityState.INACTION, (Object)true).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> entitypatch.playSound(EpicFightSounds.ROCKET_JUMP, 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {}, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
        FLY_ON_SWORD_BASIC = new StaticAnimation(false, "biped/fly_on_sword_beginner", (Armature)biped).addStateRemoveOld(EntityState.CAN_BASIC_ATTACK, (Object)true).addStateRemoveOld(EntityState.INACTION, (Object)true).addStateRemoveOld(EntityState.MOVEMENT_LOCKED, (Object)true).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                ((ServerPlayer)serverPlayerPatch.getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                    ssPlayer.isPlayingAnim = true;
                });
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                ((ServerPlayer)serverPlayerPatch.getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                    ssPlayer.isPlayingAnim = false;
                });
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        FLY_ON_SWORD_ADVANCED = new StaticAnimation(false, "biped/fly_on_sword_master", (Armature)biped).addStateRemoveOld(EntityState.CAN_BASIC_ATTACK, (Object)true).addStateRemoveOld(EntityState.INACTION, (Object)true).addStateRemoveOld(EntityState.MOVEMENT_LOCKED, (Object)true).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                ModAnimations.setPlayingAnim((Player)serverPlayerPatch.getOriginal(), true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, animation, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                ModAnimations.setPlayingAnim((Player)serverPlayerPatch.getOriginal(), false);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
    }

    public static void setPlayingAnim(Player player, boolean b) {
        player.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            ssPlayer.isPlayingAnim = b;
        });
    }
}

