/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.entity.AbstractSwordEntity;
import net.p1nero.ss.entity.ModEntities;
import net.p1nero.ss.util.ClientHelper;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.item.LongswordItem;
import yesman.epicfight.world.item.TachiItem;
import yesman.epicfight.world.item.UchigatanaItem;

public class SwordEntity
extends Entity
implements AbstractSwordEntity {
    protected Player rider;
    private static final EntityDataAccessor<Optional<UUID>> RIDER_UUID = SynchedEntityData.m_135353_(SwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(SwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public SwordEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.m_20088_().m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(RIDER_UUID, Optional.empty());
    }

    public SwordEntity(ItemStack itemStack, Player rider) {
        super((EntityType)ModEntities.SWORD.get(), rider.f_19853_);
        this.rider = rider;
        this.m_20088_().m_135372_(ITEM_STACK, (Object)itemStack);
        this.m_20088_().m_135372_(RIDER_UUID, Optional.of(rider.m_142081_()));
    }

    @Override
    public ItemStack getItemStack() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    public void setItemStack(ItemStack itemStack) {
        this.m_20088_().m_135381_(ITEM_STACK, (Object)itemStack);
    }

    public void setRider(Player rider) {
        this.rider = rider;
        this.m_20088_().m_135381_(RIDER_UUID, Optional.of(rider.m_142081_()));
    }

    public void m_8127_() {
        this.rider = null;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_19947_) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.rider == null) {
            if (this.f_19853_.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.getLocalPlayer(this.rider));
            }
            if (((Optional)this.m_20088_().m_135370_(RIDER_UUID)).isPresent()) {
                this.rider = this.f_19853_.m_46003_((UUID)((Optional)this.m_20088_().m_135370_(RIDER_UUID)).get());
            } else {
                SwordSoaring.LOGGER.info("sword entity " + this.m_142049_() + " doesn't have rider " + this.f_19853_);
                this.m_146870_();
                return;
            }
        }
        if (!this.f_19853_.f_46443_) {
            List entities = this.f_19853_.m_45933_((Entity)this.rider, this.rider.m_142469_());
            for (Entity entity : entities) {
                if (!entity.m_6921_().m_82390_(this.m_20318_(1.0f))) continue;
                entity.m_6469_(DamageSource.m_19344_((Player)this.rider), (float)this.rider.m_20184_().m_82553_() * 10.0f);
            }
        }
        this.m_146884_(new Vec3(this.rider.m_20185_(), this.rider.m_20186_(), this.rider.m_20189_()));
        this.m_146922_(this.rider.m_146908_());
        this.rider.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            if (!ssPlayer.isFlying()) {
                ssPlayer.setHasSwordEntity(false);
                SwordSoaring.LOGGER.info("sword entity " + this.m_142049_() + " rider is not flying. " + this.f_19853_);
                this.m_146870_();
            }
        });
    }

    @Override
    public void setPose(PoseStack poseStack) {
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        Item sword = this.getItemStack().m_41720_();
        if (sword instanceof UchigatanaItem || sword instanceof TachiItem || sword instanceof LongswordItem) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(45.0f + this.m_146908_()));
        } else {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-45.0f + this.m_146908_()));
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        this.m_20088_().m_135381_(RIDER_UUID, Optional.of(tag.m_128342_("rider_uuid")));
        this.m_20088_().m_135381_(ITEM_STACK, (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_("item_stack")));
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.rider != null) {
            tag.m_128362_("rider_uuid", ((Optional)this.m_20088_().m_135370_(RIDER_UUID)).orElse(this.rider.m_142081_()));
        }
        tag.m_128365_("item_stack", (Tag)((ItemStack)this.m_20088_().m_135370_(ITEM_STACK)).serializeNBT());
    }
}

