/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.entity.AbstractSwordEntity;
import net.p1nero.ss.entity.ModEntities;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.client.AddBladeRushSkillParticlePacket;
import net.p1nero.ss.network.packet.client.AddSmokeParticlePacket;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.item.LongswordItem;
import yesman.epicfight.world.item.TachiItem;
import yesman.epicfight.world.item.UchigatanaItem;

public class StellarSwordEntity
extends AbstractArrow
implements AbstractSwordEntity {
    private boolean inEntity;
    private Vec3 movement0;
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(StellarSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public StellarSwordEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.STELLAR_SWORD.get()), world);
    }

    public StellarSwordEntity(EntityType<? extends AbstractArrow> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.m_20088_().m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public StellarSwordEntity(ItemStack itemStack, Level level) {
        this((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.STELLAR_SWORD.get()), level);
        this.setItemStack(itemStack);
    }

    public void setItemStack(ItemStack itemStack) {
        this.m_20088_().m_135381_(ITEM_STACK, (Object)itemStack);
    }

    @Override
    public ItemStack getItemStack() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    public void m_20256_(@NotNull Vec3 deltaMovement) {
        super.m_20256_(deltaMovement);
        this.movement0 = deltaMovement;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 0) {
            this.f_19853_.m_7106_((ParticleOptions)EpicFightParticles.AIR_BURST.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.f_19797_ > 3) {
            this.m_20256_(this.movement0.m_82490_(0.01));
        }
        if (this.f_19797_ > 100) {
            Entity entity = this.m_37282_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
                    ssPlayer.isStellarRestorationPressing = false;
                });
                PacketRelay.sendToAll(PacketHandler.INSTANCE, new AddSmokeParticlePacket(this.m_20318_(1.0f), this.m_20184_()));
            }
            this.m_146870_();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (this.inEntity) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        Entity entity2 = this.m_37282_();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            entity.m_6469_(DamageSource.m_19344_((Player)player), 0.5f);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_21153_(livingEntity.m_21223_() - 1.0f);
            }
            this.f_19853_.m_5594_(null, this.m_20097_(), EpicFightSounds.BLADE_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            PacketRelay.sendToAll(PacketHandler.INSTANCE, new AddBladeRushSkillParticlePacket(this.m_20318_(1.0f), this.m_20184_()));
        }
        this.m_20256_(this.movement0.m_82490_(0.01));
        this.inEntity = true;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.getItemStack();
    }

    @Override
    public void setPose(PoseStack poseStack) {
        Item sword = this.getItemStack().m_41720_();
        double pitchRad = Math.toRadians(-this.m_146908_());
        double yawRad = Math.toRadians(-this.m_146909_());
        float xRot = (float)Math.toDegrees(yawRad * Math.cos(pitchRad));
        float zRot = (float)Math.toDegrees(yawRad * Math.sin(pitchRad));
        if (0.0f < -this.m_146908_() && -this.m_146908_() < 180.0f) {
            zRot = -zRot;
        }
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.m_146908_() - 90.0f));
        if (sword instanceof UchigatanaItem || sword instanceof TachiItem || sword instanceof LongswordItem) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(zRot - 45.0f));
        } else {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(zRot - 135.0f));
        }
    }
}

