/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.p1nero.ss.SwordSoaring;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.entity.ModEntities;
import net.p1nero.ss.entity.SwordEntity;
import yesman.epicfight.network.EpicFightDataSerializers;
import yesman.epicfight.world.item.LongswordItem;
import yesman.epicfight.world.item.TachiItem;
import yesman.epicfight.world.item.UchigatanaItem;

public class RainScreenSwordEntity
extends SwordEntity {
    private static final EntityDataAccessor<Optional<UUID>> RIDER_UUID = SynchedEntityData.m_135353_(RainScreenSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(RainScreenSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> RAIN_SCREEN_SWORD_ID = SynchedEntityData.m_135353_(RainScreenSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Vec3> OLD_POS = SynchedEntityData.m_135353_(RainScreenSwordEntity.class, (EntityDataSerializer)EpicFightDataSerializers.VEC3);

    public RainScreenSwordEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.m_20088_().m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(RIDER_UUID, Optional.empty());
        this.m_20088_().m_135372_(RAIN_SCREEN_SWORD_ID, (Object)-1);
        this.m_20088_().m_135372_(OLD_POS, (Object)this.m_20182_());
    }

    public RainScreenSwordEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ModEntities.RAIN_SCREEN_SWORD.get(), level);
    }

    @Override
    public ItemStack getItemStack() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    @Override
    public void setItemStack(ItemStack itemStack) {
        this.m_20088_().m_135381_(ITEM_STACK, (Object)itemStack);
    }

    @Override
    public void setRider(Player rider) {
        this.rider = rider;
        this.m_20088_().m_135381_(RIDER_UUID, Optional.of(rider.m_142081_()));
    }

    public void setSwordID(int swordID) {
        this.m_20088_().m_135381_(RAIN_SCREEN_SWORD_ID, (Object)swordID);
    }

    public int getRainScreenSwordId() {
        return (Integer)this.m_20088_().m_135370_(RAIN_SCREEN_SWORD_ID);
    }

    @Override
    public void m_8119_() {
        if (this.rider == null) {
            if (((Optional)this.m_20088_().m_135370_(RIDER_UUID)).isPresent()) {
                this.rider = this.f_19853_.m_46003_((UUID)((Optional)this.m_20088_().m_135370_(RIDER_UUID)).get());
            }
            SwordSoaring.LOGGER.info("sword entity {} doesn't have rider {}", (Object)this.m_142049_(), (Object)this.f_19853_);
            this.m_146870_();
            return;
        }
        if (this.f_19853_ instanceof ServerLevel) {
            Vec3 center = this.rider.m_20182_();
            double radians = (double)this.f_19797_ * 0.1 + (double)this.getRainScreenSwordId() * Math.PI / 2.0;
            Vec3 targetPos = new Vec3(center.f_82479_ + Math.cos(radians) * 1.3, center.f_82480_ + Math.sin((double)this.f_19797_ * 0.1) * 0.3 + 0.3, center.f_82481_ + Math.sin(radians) * 1.3);
            this.m_20088_().m_135381_(OLD_POS, (Object)new Vec3(this.f_19790_, this.f_19791_, this.f_19792_));
            this.m_146884_(targetPos);
        }
        SSPlayer ssPlayer = (SSPlayer)this.rider.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
        if (this.f_19797_ > 200) {
            if (!this.f_19853_.f_46443_) {
                ssPlayer.getSwordScreensID().remove(this.m_142049_());
            }
            ssPlayer.setSwordScreenEntityCount(ssPlayer.getSwordScreenEntityCount() - 1);
            this.m_146870_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_20059_) {
        super.m_7350_(p_20059_);
        if (this.f_19853_.f_46443_ && OLD_POS.equals(p_20059_)) {
            Vec3 oldPos = (Vec3)this.m_20088_().m_135370_(OLD_POS);
            this.f_19790_ = oldPos.f_82479_;
            this.f_19791_ = oldPos.f_82480_;
            this.f_19792_ = oldPos.f_82481_;
        }
    }

    @Override
    public void setPose(PoseStack poseStack) {
        Item sword = this.getItemStack().m_41720_();
        if (sword instanceof UchigatanaItem || sword instanceof TachiItem || sword instanceof LongswordItem) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(225.0f));
            poseStack.m_85837_(-0.8, -0.8, 0.0);
        } else {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-225.0f));
            poseStack.m_85837_(0.8, -0.8, 0.0);
        }
    }
}

