/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.p1nero.ss.entity.AbstractSwordEntity;
import net.p1nero.ss.entity.ModEntities;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.client.AddBladeRushSkillParticlePacket;
import net.p1nero.ss.network.packet.client.AddSmokeParticlePacket;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.item.LongswordItem;
import yesman.epicfight.world.item.TachiItem;
import yesman.epicfight.world.item.UchigatanaItem;

public class RainCutterSwordEntity
extends AbstractArrow
implements AbstractSwordEntity {
    public static final float speed = 1.0f;
    private Vec3 targetPos = Vec3.f_82478_;
    private Vec3 dir = Vec3.f_82478_;
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(RainCutterSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> RAIN_CUTTER_SWORD_ID = SynchedEntityData.m_135353_(RainCutterSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public RainCutterSwordEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.RAIN_CUTTER_SWORD.get()), world);
    }

    public RainCutterSwordEntity(EntityType<? extends AbstractArrow> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.m_20088_().m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(RAIN_CUTTER_SWORD_ID, (Object)-1);
    }

    public RainCutterSwordEntity(ItemStack itemStack, Level level, int swordID) {
        this((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.RAIN_CUTTER_SWORD.get()), level);
        this.setSwordID(swordID);
        this.setItemStack(itemStack);
    }

    public void setItemStack(ItemStack itemStack) {
        this.m_20088_().m_135381_(ITEM_STACK, (Object)itemStack);
    }

    @Override
    public ItemStack getItemStack() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setSwordID(int swordID) {
        this.m_20088_().m_135381_(RAIN_CUTTER_SWORD_ID, (Object)swordID);
    }

    public int getRainCutterSwordId() {
        return (Integer)this.m_20088_().m_135370_(RAIN_CUTTER_SWORD_ID);
    }

    public Vec3 getOffset() {
        double dis = 1.3;
        double yRot = Math.toRadians(Objects.requireNonNull(this.m_37282_()).m_146908_());
        return switch (this.getRainCutterSwordId()) {
            case 0 -> new Vec3(-dis * Math.cos(yRot), 2.5, -dis * Math.sin(yRot));
            case 1 -> new Vec3(0.0, 3.0, 0.0);
            case 2 -> new Vec3(dis * Math.cos(yRot), 2.5, dis * Math.sin(yRot));
            default -> new Vec3(0.0, 0.0, 0.0);
        };
    }

    public void m_8119_() {
        Vec3 vec33;
        VoxelShape voxelshape;
        boolean flag = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        BlockPos blockpos = this.m_142538_();
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            vec33 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec33)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        this.m_20095_();
        if (this.f_36703_ && !flag) {
            ++this.f_36704_;
        } else {
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_146910_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_37282_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            if (this.m_146910_()) {
                return;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            float f = 0.99f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.m_6882_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
        if (this.f_19803_) {
            this.f_19853_.m_7106_((ParticleOptions)EpicFightParticles.AIR_BURST.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.f_19803_ = false;
        }
        this.updateDir();
        this.m_20256_(this.dir.m_82541_().m_82490_(1.0));
        if (!this.f_19853_.f_46443_) {
            this.m_146922_((float)Math.toDegrees(Math.atan2(this.dir.f_82479_, this.dir.f_82481_)));
            this.m_146926_((float)Math.toDegrees(Math.atan2(this.dir.f_82480_, this.dir.m_165924_())));
            if (this.f_19797_ > 100 || this.f_36704_ > 2) {
                PacketRelay.sendToAll(PacketHandler.INSTANCE, new AddSmokeParticlePacket(this.m_20318_(1.0f), this.m_20184_()));
                this.m_146870_();
            }
        }
    }

    public void updateDir() {
        Entity entity = this.m_37282_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_37282_().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                if (entityPatch instanceof PlayerPatch) {
                    PlayerPatch playerPatch = (PlayerPatch)entityPatch;
                    if (playerPatch.getTarget() == null) {
                        this.dir = player.m_20252_(1.0f);
                    } else {
                        LivingEntity target = playerPatch.getTarget();
                        this.targetPos = target.m_20318_(1.0f).m_82520_(0.0, (double)target.m_20192_(), 0.0);
                        this.dir = this.targetPos.m_82546_(this.m_20318_(1.0f));
                    }
                }
            });
        }
    }

    public void initDirection() {
        this.updateDir();
        this.m_20256_(this.dir.m_82541_().m_82490_(1.0));
        this.m_146922_((float)Math.toDegrees(Math.atan2(this.dir.f_82479_, this.dir.f_82481_)));
        this.m_146926_((float)Math.toDegrees(Math.atan2(this.dir.f_82480_, this.dir.m_165924_())));
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        Entity entity2 = this.m_37282_();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            if (entity.m_142049_() != player.m_142049_()) {
                entity.m_6469_(DamageSource.m_19344_((Player)player), 0.5f);
                int fireLevel = this.getItemStack().getItemEnchantability();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_21153_(livingEntity.m_21223_() - 1.0f);
                }
                this.f_19853_.m_5594_(null, this.m_20097_(), EpicFightSounds.BLADE_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                PacketRelay.sendToAll(PacketHandler.INSTANCE, new AddBladeRushSkillParticlePacket(this.m_20318_(1.0f), this.m_20184_()));
                this.m_146870_();
            }
        }
        super.m_5790_(entityHitResult);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.getItemStack();
    }

    @Override
    public void setPose(PoseStack poseStack) {
        Item sword = this.getItemStack().m_41720_();
        double pitchRad = Math.toRadians(-this.m_146908_());
        double yawRad = Math.toRadians(-this.m_146909_());
        float xRot = (float)Math.toDegrees(yawRad * Math.cos(pitchRad));
        float zRot = (float)Math.toDegrees(yawRad * Math.sin(pitchRad));
        if (0.0f < -this.m_146908_() && -this.m_146908_() < 180.0f) {
            zRot = -zRot;
        }
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.m_146908_() - 90.0f));
        if (sword instanceof UchigatanaItem || sword instanceof TachiItem || sword instanceof LongswordItem) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(zRot - 45.0f));
        } else {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(zRot - 135.0f));
        }
    }
}

