/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.p1nero.ss.capability.SSPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="sword_soaring", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SSCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<SSPlayer> SS_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<SSPlayer>(){});
    private SSPlayer ssPlayer = null;
    private final LazyOptional<SSPlayer> optional = LazyOptional.of(this::createSSPlayer);

    private SSPlayer createSSPlayer() {
        if (this.ssPlayer == null) {
            this.ssPlayer = new SSPlayer();
        }
        return this.ssPlayer;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == SS_PLAYER) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createSSPlayer().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createSSPlayer().loadNBTData(tag);
    }

    @Mod.EventBusSubscriber(modid="sword_soaring")
    public static class Registration {
        @SubscribeEvent
        public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(SS_PLAYER).isPresent()) {
                event.addCapability(new ResourceLocation("sword_soaring", "ss_player"), (ICapabilityProvider)new SSCapabilityProvider());
            }
        }

        @SubscribeEvent
        public static void onPlayerCloned(PlayerEvent.Clone event) {
            if (event.isWasDeath()) {
                event.getOriginal().getCapability(SS_PLAYER).ifPresent(oldStore -> event.getOriginal().getCapability(SS_PLAYER).ifPresent(newStore -> newStore.copyFrom((SSPlayer)oldStore)));
            }
        }

        @SubscribeEvent
        public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
            event.register(SSPlayer.class);
        }
    }
}

