/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.p1nero.ss.Config;
import net.p1nero.ss.enchantment.ModEnchantments;
import net.p1nero.ss.entity.ModEntities;
import net.p1nero.ss.entity.SwordEntityRenderer;
import net.p1nero.ss.epicfight.skill.ModSkills;
import net.p1nero.ss.epicfight.skill.RainCutter;
import net.p1nero.ss.epicfight.skill.RainScreen;
import net.p1nero.ss.epicfight.skill.StellarRestoration;
import net.p1nero.ss.epicfight.skill.SwordSoaringSkill;
import net.p1nero.ss.epicfight.skill.YakshaMask;
import net.p1nero.ss.network.PacketHandler;
import org.slf4j.Logger;
import yesman.epicfight.config.ConfigManager;
import yesman.epicfight.data.loot.function.SetSkillFunction;
import yesman.epicfight.world.item.EpicFightItems;

@Mod(value="sword_soaring")
public class SwordSoaring {
    public static final String MOD_ID = "sword_soaring";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SwordSoaring() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        IEventBus fg_bus = MinecraftForge.EVENT_BUS;
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModEntities.ENTITIES.register(bus);
        ModEnchantments.ENCHANTMENTS.register(bus);
        fg_bus.addListener(ModSkills::BuildSkills);
        fg_bus.addListener(RainScreen::onPlayerTick);
        fg_bus.addListener(RainCutter::onPlayerTick);
        fg_bus.addListener(SwordSoaringSkill::onPlayerTick);
        fg_bus.addListener(YakshaMask::onPlayerTick);
        fg_bus.addListener(StellarRestoration::onPlayerTick);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        ModSkills.registerSkills();
    }

    public static boolean isWOMLoaded() {
        return ModList.get().isLoaded("wom");
    }

    public static boolean isValidSword(ItemStack sword) {
        if (Config.swordItems.isEmpty()) {
            Config.swordItems = ((List)Config.ITEMS_CAN_FLY.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).collect(Collectors.toSet());
            Config.notSwordItems = ((List)Config.ITEMS_CAN_NOT_FLY.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).collect(Collectors.toSet());
            Config.swordItems.removeAll(Config.notSwordItems);
        }
        if (Config.notSwordItems.contains(sword.m_41720_())) {
            return false;
        }
        return sword.m_41720_() instanceof SwordItem || Config.swordItems.contains(sword.m_41720_());
    }

    @Mod.EventBusSubscriber(modid="sword_soaring")
    public static class ModEvents {
        @SubscribeEvent
        public static void modifyVanillaLootPools(LootTableLoadEvent event) {
            if (!((Boolean)Config.ENABLE_LOOT_TABLE.get()).booleanValue()) {
                return;
            }
            int modifier = (Integer)ConfigManager.SKILL_BOOK_CHEST_LOOT_MODIFYER.get();
            int dropChance = 100 + modifier;
            int antiDropChance = 100 - modifier;
            float dropChanceModifier = (float)dropChance / (float)(antiDropChance + dropChance);
            String[] skills = new String[]{"sword_soaring:sword_soaring", "sword_soaring:rain_cutter", "sword_soaring:yaksha_mask", "sword_soaring:stellar_restoration", "sword_soaring:rain_screen"};
            if (event.getName().equals((Object)BuiltInLootTables.f_78741_)) {
                event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder((String[])skills)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)dropChanceModifier))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78722_)) {
                event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder((String[])skills)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)dropChanceModifier))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78761_)) {
                event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder((String[])skills))).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(dropChanceModifier * 0.3f))).m_79082_());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="sword_soaring", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SWORD.get()), SwordEntityRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.RAIN_SCREEN_SWORD.get()), SwordEntityRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.RAIN_CUTTER_SWORD.get()), SwordEntityRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STELLAR_SWORD.get()), SwordEntityRenderer::new);
        }
    }
}

