/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="sword_soaring", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue ENABLE_LOOT_TABLE = Config.createBool("if true, you can get all skill books via fishing, end city, ancient city and strong hold library. or you have to add loot table yourself(for mod pack author)", "enable_loot_table", true);
    public static final ForgeConfigSpec.DoubleValue SWORD_SOARING_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue RAIN_SCREEN_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue RAIN_CUTTER_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue YAKSHAS_MASK_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue STELLAR_RESTORATION_COOLDOWN;
    public static final ForgeConfigSpec.BooleanValue FORCE_FLY_ANIM;
    public static final ForgeConfigSpec.BooleanValue ENABLE_INERTIA;
    public static final ForgeConfigSpec.DoubleValue INERTIA_TICK_BEFORE;
    public static final ForgeConfigSpec.DoubleValue FLY_SPEED_SCALE;
    public static final ForgeConfigSpec.DoubleValue STAMINA_CONSUME_PER_TICK;
    public static final ForgeConfigSpec.DoubleValue MAX_ANTICIPATION_TICK;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEMS_CAN_FLY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEMS_CAN_NOT_FLY;
    static final ForgeConfigSpec SPEC;
    public static Set<Item> swordItems;
    public static Set<Item> notSwordItems;

    private static ForgeConfigSpec.BooleanValue createBool(String key, boolean defaultValue) {
        return BUILDER.translation("config.sword_soaring." + key).define(key, defaultValue);
    }

    private static ForgeConfigSpec.BooleanValue createBool(String comment, String key, boolean defaultValue) {
        return BUILDER.comment(comment).translation("config.sword_soaring." + key).define(key, defaultValue);
    }

    private static ForgeConfigSpec.DoubleValue createDouble(String comment, String key, double defaultValue) {
        return BUILDER.comment(comment).translation("config.sword_soaring." + key).defineInRange(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sword_soaring").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"rain_screen_cooldown").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(RAIN_SCREEN_COOLDOWN, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"rain_cutter_cooldown").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(RAIN_CUTTER_COOLDOWN, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"yaksha_mask_cooldown").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(YAKSHAS_MASK_COOLDOWN, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"stellar_restoration_cooldown").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(STELLAR_RESTORATION_COOLDOWN, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"force_fly_anim").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> Config.setConfig(FORCE_FLY_ANIM, BoolArgumentType.getBool((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"enable_inertia").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> Config.setConfig(ENABLE_INERTIA, BoolArgumentType.getBool((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"inertia_tick_before").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(INERTIA_TICK_BEFORE, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"fly_speed_scale").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(FLY_SPEED_SCALE, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"stamina_consume_per_tick").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(STAMINA_CONSUME_PER_TICK, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"max_anticipation_tick").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> Config.setConfig(MAX_ANTICIPATION_TICK, DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource())))));
    }

    private static int setConfig(ForgeConfigSpec.DoubleValue config, double value, CommandSourceStack stack) {
        config.set((Object)value);
        stack.m_81354_(Component.m_130674_((String)("Successfully set to : " + value)), true);
        return 0;
    }

    private static int setConfig(ForgeConfigSpec.BooleanValue config, boolean value, CommandSourceStack stack) {
        config.set((Object)value);
        stack.m_81354_(Component.m_130674_((String)("Successfully set to : " + value)), true);
        return 0;
    }

    static {
        BUILDER.push("Skill Cooldown");
        SWORD_SOARING_COOLDOWN = Config.createDouble("the cooldown ticks of Rain Screen skill", "sword_soaring_cooldown", 0.0);
        RAIN_SCREEN_COOLDOWN = Config.createDouble("the cooldown ticks of Rain Screen skill", "rain_screen_cooldown", 862.0);
        RAIN_CUTTER_COOLDOWN = Config.createDouble("the cooldown ticks of Rain Cutter skill", "rain_cutter_cooldown", 816.0);
        YAKSHAS_MASK_COOLDOWN = Config.createDouble("the cooldown ticks of Yaksha's Mask skill", "yaksha_mask_cooldown", 749.0);
        STELLAR_RESTORATION_COOLDOWN = Config.createDouble("the cooldown ticks of Stellar Restoration skill", "stellar_restoration_cooldown", 312.0);
        BUILDER.pop();
        BUILDER.push("Sword Soaring");
        FORCE_FLY_ANIM = Config.createBool("force_fly_anim", false);
        ENABLE_INERTIA = Config.createBool("enable_inertia", true);
        INERTIA_TICK_BEFORE = Config.createDouble("the inertia end.(delay time) only work when enable_inertia is true. Shouldn't larger than 100!!!", "inertia_tick_before", 10.0);
        FLY_SPEED_SCALE = Config.createDouble("the ratio of flying speed to view vector", "fly_speed_scale", 0.6);
        STAMINA_CONSUME_PER_TICK = Config.createDouble("the stamina consumed per end when flying", "stamina_consume_per_tick", 0.05);
        MAX_ANTICIPATION_TICK = Config.createDouble("ticks of end taking off", "max_anticipation_tick", 10.0);
        ITEMS_CAN_FLY = BUILDER.comment("A list of items considered as sword.").defineListAllowEmpty(List.of("items can fly"), () -> List.of("minecraft:iron_ingot"), Config::validateItemName);
        ITEMS_CAN_NOT_FLY = BUILDER.comment("A list of items not considered as sword.").defineListAllowEmpty(List.of("items can't fly"), () -> List.of("minecraft:iron_ingot"), Config::validateItemName);
        BUILDER.pop();
        SPEC = BUILDER.build();
        swordItems = new HashSet<Item>();
        notSwordItems = new HashSet<Item>();
    }
}

