/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixManager;
import top.theillusivec4.champions.common.integration.scalinghealth.ScalingHealthPlugin;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.EntityManager;

public class ChampionData {
    private static final String CHAMPION_KEY = "ChampionsData";
    private static final Random RAND = new Random();

    public static boolean read(IChampion champion) {
        CompoundTag championTag;
        LivingEntity livingEntity = champion.getLivingEntity();
        CompoundTag tag = livingEntity.getPersistentData();
        if (!tag.m_128456_() && !(championTag = tag.m_128469_(CHAMPION_KEY)).m_128456_()) {
            Rank rank = RankManager.getLowestRank();
            if (championTag.m_128441_("tier")) {
                if (championTag.m_128425_("tier", 3)) {
                    rank = RankManager.getRank(championTag.m_128451_("tier"));
                } else if (championTag.m_128425_("tier", 10)) {
                    CompoundTag valueTag = championTag.m_128469_("tier");
                    Integer min = valueTag.m_128441_("min") ? Integer.valueOf(valueTag.m_128451_("min")) : null;
                    Integer max = valueTag.m_128441_("max") ? Integer.valueOf(valueTag.m_128451_("max")) : null;
                    rank = ChampionData.createRank(livingEntity, min, max);
                }
            }
            champion.getServer().setRank(rank);
            ArrayList<IAffix> affixes = new ArrayList<IAffix>();
            HashSet<String> ids = new HashSet<String>();
            Integer count = null;
            if (championTag.m_128441_("affixes")) {
                if (championTag.m_128425_("affixes", 9)) {
                    ListTag listTag = championTag.m_128437_("affixes", 8);
                    for (int i = 0; i < listTag.size(); ++i) {
                        ids.add(listTag.m_128778_(i));
                    }
                } else if (championTag.m_128425_("affixes", 10)) {
                    CompoundTag affixesTag = championTag.m_128469_("affixes");
                    count = affixesTag.m_128425_("count", 3) ? Integer.valueOf(affixesTag.m_128451_("count")) : null;
                    ListTag listTag = affixesTag.m_128437_("values", 8);
                    for (int i = 0; i < listTag.size(); ++i) {
                        ids.add(listTag.m_128778_(i));
                    }
                }
            }
            for (String id : ids) {
                Champions.API.getAffix(id).ifPresent(affixes::add);
            }
            int totalAffixes = count == null ? rank.getNumAffixes() : count.intValue();
            int toAdd = totalAffixes - affixes.size();
            if (toAdd > 0) {
                ChampionData.createAffixes(affixes, champion, totalAffixes);
            }
            ChampionBuilder.applyGrowth(livingEntity, rank.getGrowthFactor());
            champion.getServer().setAffixes(affixes);
            affixes.forEach(affix -> affix.onInitialSpawn(champion));
            return true;
        }
        return false;
    }

    private static void createAffixes(List<IAffix> affixes, IChampion champion, int total) {
        Map<AffixCategory, List<IAffix>> allAffixes = Champions.API.getCategoryMap();
        HashMap<AffixCategory, List> validAffixes = new HashMap<AffixCategory, List>();
        Optional<EntityManager.EntitySettings> entitySettings = EntityManager.getSettings(champion.getLivingEntity().m_6095_());
        for (AffixCategory category : Champions.API.getCategories()) {
            validAffixes.put(category, new ArrayList());
        }
        allAffixes.forEach((k, v) -> ((List)validAffixes.get(k)).addAll(v.stream().filter(affix -> {
            Optional<AffixManager.AffixSettings> settings = AffixManager.getSettings(affix.getIdentifier());
            return !affixes.contains(affix) && entitySettings.map(entitySettings1 -> entitySettings1.canApply((IAffix)affix)).orElse(true) != false && settings.map(affixSettings -> affixSettings.canApply(champion)).orElse(true) != false && affix.canApply(champion);
        }).collect(Collectors.toList())));
        ArrayList randomList = new ArrayList();
        validAffixes.forEach((k, v) -> randomList.addAll(v));
        while (randomList.size() > 0 && affixes.size() < total) {
            int randomIndex = RAND.nextInt(randomList.size());
            IAffix randomAffix = (IAffix)randomList.get(randomIndex);
            if (affixes.stream().allMatch(affix -> affix.isCompatible(randomAffix) && (randomAffix.getCategory() == AffixCategory.OFFENSE || affix.getCategory() != randomAffix.getCategory()))) {
                affixes.add(randomAffix);
            }
            randomList.remove(randomIndex);
        }
    }

    private static Rank createRank(LivingEntity livingEntity, Integer min, Integer max) {
        if (!ChampionHelper.checkPotential(livingEntity)) {
            return RankManager.getLowestRank();
        }
        ImmutableSortedMap<Integer, Rank> ranks = RankManager.getRanks();
        if (ranks.isEmpty()) {
            Champions.LOGGER.error("No rank configuration found! Please check the 'champions-ranks.toml' file in the 'serverconfigs'.");
            return RankManager.getLowestRank();
        }
        Integer[] tierRange = new Integer[]{min, max};
        Integer firstTier = tierRange[0] != null ? tierRange[0] : (Integer)ranks.firstKey();
        int maxTier = tierRange[1] != null ? tierRange[1] : -1;
        UnmodifiableIterator iter = ranks.navigableKeySet().tailSet((Object)firstTier, false).iterator();
        Rank result = (Rank)ranks.get((Object)firstTier);
        if (result == null) {
            Champions.LOGGER.error("Tier {} cannot be found in {}! Assigning lowest available rank to {}", (Object)firstTier, ranks, (Object)livingEntity);
            return RankManager.getLowestRank();
        }
        while (iter.hasNext() && (result.getTier() < maxTier || maxTier == -1)) {
            Rank rank = (Rank)ranks.get(iter.next());
            if (rank == null) {
                return result;
            }
            float chance = rank.getChance();
            if (Champions.scalingHealthLoaded) {
                chance = (float)((double)chance + ScalingHealthPlugin.getSpawnIncrease(rank.getTier(), livingEntity));
            }
            if (RAND.nextFloat() < chance) {
                result = rank;
                continue;
            }
            return result;
        }
        return result;
    }
}

