/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ShulkerBulletModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import top.theillusivec4.champions.common.entity.BaseBulletEntity;

public class ColorizedBulletRenderer
extends EntityRenderer<BaseBulletEntity> {
    private static final ResourceLocation GENERIC_SPARK_TEXTURE = new ResourceLocation("champions", "textures/entity/generic_spark.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)GENERIC_SPARK_TEXTURE);
    private final ShulkerBulletModel<BaseBulletEntity> model;
    private final int color;

    public ColorizedBulletRenderer(EntityRendererProvider.Context manager, int color) {
        super(manager);
        this.color = color;
        this.model = new ShulkerBulletModel(manager.m_174023_(ModelLayers.f_171181_));
    }

    protected int getBlockLightLevel(@Nonnull BaseBulletEntity bullet, @Nonnull BlockPos blockPos) {
        return 15;
    }

    public void render(BaseBulletEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        float yRot = Mth.m_14189_((float)entity.f_19859_, (float)entity.m_146908_(), (float)partialTicks);
        float xRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        float tickModifier = (float)entity.f_19797_ + partialTicks;
        matrixStack.m_85837_(0.0, (double)0.15f, 0.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14031_((float)(tickModifier * 0.1f)) * 180.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14089_((float)(tickModifier * 0.1f)) * 180.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)(tickModifier * 0.15f)) * 360.0f));
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        matrixStack.m_85841_(-0.5f, -0.5f, 0.5f);
        this.model.m_6973_((Entity)entity, 0.0f, 0.0f, 0.0f, yRot, xRot);
        VertexConsumer vertexconsumer = buffer.m_6299_(this.model.m_103119_(GENERIC_SPARK_TEXTURE));
        this.model.m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        matrixStack.m_85841_(1.5f, 1.5f, 1.5f);
        VertexConsumer vertexconsumer1 = buffer.m_6299_(RENDER_TYPE);
        this.model.m_7695_(matrixStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_, r, g, b, 0.15f);
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull BaseBulletEntity entity) {
        return GENERIC_SPARK_TEXTURE;
    }
}

