/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLEnvironment;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.handler.PacketHandler;
import sereneseasons.handler.season.RandomUpdateHandler;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.handler.season.SeasonalCropGrowthHandler;
import sereneseasons.handler.season.TimeSkipHandler;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColorUtil;

public class ModHandlers {
    private static final SeasonHandler SEASON_HANDLER = new SeasonHandler();
    @OnlyIn(value=Dist.CLIENT)
    private static ColorResolver originalGrassColorResolver;
    @OnlyIn(value=Dist.CLIENT)
    private static ColorResolver originalFoliageColorResolver;

    public static void init() {
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)SEASON_HANDLER);
        SeasonHelper.dataProvider = SEASON_HANDLER;
        MinecraftForge.EVENT_BUS.register((Object)new RandomUpdateHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeasonalCropGrowthHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TimeSkipHandler());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ModHandlers.registerSeasonColourHandlers();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerSeasonColourHandlers() {
        originalGrassColorResolver = BiomeColors.f_108789_;
        originalFoliageColorResolver = BiomeColors.f_108790_;
        BiomeColors.f_108789_ = (biome, x, z) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Registry biomeRegistry = level.m_5962_().m_175515_(Registry.f_122885_);
            Holder biomeHolder = biomeRegistry.m_7854_((Object)biome).flatMap(key -> Optional.of(biomeRegistry.m_203538_(key))).orElse(null);
            int originalColor = originalGrassColorResolver.m_130045_(biome, x, z);
            if (biomeHolder != null) {
                SeasonTime calendar = SeasonHandler.getClientSeasonTime();
                Enum colorProvider = BiomeConfig.usesTropicalSeasons((Holder<Biome>)biomeHolder) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                return SeasonColorUtil.applySeasonalGrassColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
            }
            return originalColor;
        };
        BiomeColors.f_108790_ = (biome, x, z) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Registry biomeRegistry = level.m_5962_().m_175515_(Registry.f_122885_);
            Holder biomeHolder = biomeRegistry.m_7854_((Object)biome).flatMap(key -> Optional.of(biomeRegistry.m_203538_(key))).orElse(null);
            int originalColor = originalFoliageColorResolver.m_130045_(biome, x, z);
            if (biomeHolder != null) {
                SeasonTime calendar = SeasonHandler.getClientSeasonTime();
                Enum colorProvider = BiomeConfig.usesTropicalSeasons((Holder<Biome>)biomeHolder) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                return SeasonColorUtil.applySeasonalFoliageColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
            }
            return originalColor;
        };
    }
}

