/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.components;

import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.components.IComponent;
import com.majruszsdifficulty.undeadarmy.data.MobInfo;
import com.majruszsdifficulty.undeadarmy.data.Phase;
import com.mlib.text.TextHelper;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

class ProgressIndicator
implements IComponent {
    final ServerBossEvent waveInfo = (ServerBossEvent)new ServerBossEvent((Component)new TextComponent(""), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10).m_7006_(true);
    final ServerBossEvent bossInfo = new ServerBossEvent((Component)new TextComponent(""), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6);
    final UndeadArmy undeadArmy;

    public ProgressIndicator(UndeadArmy undeadArmy) {
        this.undeadArmy = undeadArmy;
        this.waveInfo.m_8321_(false);
        this.bossInfo.m_8321_(false);
    }

    @Override
    public void tick() {
        this.updateVisibility();
        this.updateParticipants();
        this.updateProgress();
    }

    @Override
    public void onStateChanged() {
        this.waveInfo.m_6456_(this.getPhaseComponent());
        if (this.undeadArmy.phase.state == Phase.State.FINISHED) {
            this.removeParticipants();
        }
    }

    @Override
    public void onGameReload() {
        this.waveInfo.m_6456_(this.getPhaseComponent());
    }

    private void updateVisibility() {
        boolean isBossAlive = this.undeadArmy.boss != null;
        this.waveInfo.m_8321_(this.undeadArmy.phase.state != Phase.State.STARTED);
        if (!this.bossInfo.m_8323_() && isBossAlive) {
            this.bossInfo.m_6456_(this.getBossName());
        }
        this.bossInfo.m_8321_(isBossAlive);
    }

    private void updateParticipants() {
        if (this.undeadArmy.phase.state == Phase.State.FINISHED) {
            return;
        }
        ArrayList currentParticipants = new ArrayList(this.waveInfo.m_8324_());
        this.undeadArmy.participants.forEach(player -> {
            if (!currentParticipants.contains(player)) {
                this.waveInfo.m_6543_(player);
                this.bossInfo.m_6543_(player);
            }
        });
        currentParticipants.forEach(player -> {
            if (!this.undeadArmy.participants.contains(player)) {
                this.waveInfo.m_6539_(player);
                this.bossInfo.m_6539_(player);
            }
        });
    }

    private void updateProgress() {
        switch (this.undeadArmy.phase.state) {
            case STARTED: {
                this.waveInfo.m_142711_(0.0f);
                break;
            }
            case WAVE_PREPARING: {
                this.waveInfo.m_142711_(this.undeadArmy.phase.getRatio());
                this.bossInfo.m_142711_(0.0f);
                break;
            }
            case WAVE_ONGOING: {
                this.waveInfo.m_142711_(this.getHealthRatioLeft());
                this.bossInfo.m_142711_(this.getBossHealthRatioLeft());
                break;
            }
            case UNDEAD_DEFEATED: {
                this.waveInfo.m_142711_(0.0f);
                break;
            }
            case UNDEAD_WON: {
                this.waveInfo.m_142711_(1.0f);
            }
        }
    }

    private void removeParticipants() {
        this.waveInfo.m_7706_();
        this.bossInfo.m_7706_();
    }

    private Component getPhaseComponent() {
        return switch (this.undeadArmy.phase.state) {
            case Phase.State.WAVE_PREPARING -> new TranslatableComponent(String.format("majruszsdifficulty.undead_army.%s", this.undeadArmy.currentWave > 0 ? "between_waves" : "title"));
            case Phase.State.WAVE_ONGOING -> new TranslatableComponent("majruszsdifficulty.undead_army.title").m_130946_(" ").m_7220_((Component)new TranslatableComponent("majruszsdifficulty.undead_army.wave", new Object[]{TextHelper.toRoman((int)this.undeadArmy.currentWave)}));
            case Phase.State.UNDEAD_DEFEATED -> new TranslatableComponent("majruszsdifficulty.undead_army.victory");
            case Phase.State.UNDEAD_WON -> new TranslatableComponent("majruszsdifficulty.undead_army.failed");
            default -> new TextComponent("");
        };
    }

    private float getHealthRatioLeft() {
        if (this.hasAnyNotYetSpawnedMobs()) {
            return 1.0f;
        }
        float healthLeft = 0.0f;
        float healthTotal = Math.max((float)this.undeadArmy.phase.healthTotal, 1.0f);
        for (MobInfo mobInfo : this.undeadArmy.mobsLeft) {
            healthLeft += mobInfo.getHealth(this.undeadArmy.level);
        }
        return Mth.m_14036_((float)(healthLeft / healthTotal), (float)0.0f, (float)1.0f);
    }

    private boolean hasAnyNotYetSpawnedMobs() {
        return this.undeadArmy.mobsLeft.stream().allMatch(mob -> mob.toEntity(this.undeadArmy.level) == null);
    }

    private float getBossHealthRatioLeft() {
        float f;
        Entity entity = this.undeadArmy.boss;
        if (entity instanceof LivingEntity) {
            LivingEntity boss = (LivingEntity)entity;
            f = Mth.m_14036_((float)(boss.m_21223_() / boss.m_21233_()), (float)0.0f, (float)1.0f);
        } else {
            f = 0.0f;
        }
        return f;
    }

    private Component getBossName() {
        return this.undeadArmy.boss.m_5446_().m_6881_().m_130940_(ChatFormatting.RED);
    }
}

