/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.MobGroupConfig;
import com.majruszsdifficulty.contexts.base.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.undeadarmy.data.ExtraLootInfo;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnSpawned;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

@AutoInstance
public class UndeadArmyPatrol
implements Supplier<MobGroupConfig> {
    final MobGroupConfig mobGroups = new MobGroupConfig(() -> (EntityType)Random.next(List.of(EntityType.f_20501_, EntityType.f_20458_, EntityType.f_20524_, EntityType.f_20481_)), (Range<Integer>)new Range((Number)2, (Number)4), Registries.getLocation("undead_army/equipment_wave_3"), Registries.getLocation("undead_army/equipment_wave_2"));

    public UndeadArmyPatrol() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("UndeadArmyPatrol").comment("Undead mobs may spawn in groups as the Undead Army Patrol.");
        OnSpawned.listenSafe(this::spawnGroup).addCondition(CustomConditions.gameStageAtLeast(GameStage.NORMAL)).addCondition(Condition.chanceCRD((double)0.1, (boolean)true)).addCondition(CustomConditions.isNotPartOfGroup(data -> data.target)).addCondition(CustomConditions.isNotPartOfUndeadArmy(data -> data.target)).addCondition(CustomConditions.isNotNearUndeadArmy(data -> data.target)).addCondition(Condition.isServer()).addCondition(Condition.isLevel((ResourceKey[])new ResourceKey[]{Level.f_46428_})).addCondition(Condition.excludable()).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(OnSpawned.is((Class[])new Class[]{Zombie.class, Skeleton.class, Husk.class, Stray.class})).addConfigs(new IConfigurable[]{this.mobGroups.name("Undead")}).insertTo(group);
    }

    @Override
    public MobGroupConfig get() {
        return this.mobGroups;
    }

    private void spawnGroup(OnSpawned.Data data) {
        PathfinderMob leader = (PathfinderMob)data.target;
        List<PathfinderMob> mobs = this.mobGroups.spawn(leader);
        mobs.add(leader);
        mobs.forEach(ExtraLootInfo::addExtraLootTag);
    }
}

