/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.undeadarmy.data.ExtraLootInfo;
import com.majruszsdifficulty.undeadarmy.data.UndeadArmyInfo;
import com.majruszsdifficulty.undeadarmy.data.WaveDef;
import com.majruszsdifficulty.undeadarmy.data.WavesDef;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.contexts.OnDeath;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.OnServerTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.data.JsonListener;
import com.mlib.data.SerializableHelper;
import com.mlib.levels.LevelHelper;
import com.mlib.loot.LootHelper;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@AutoInstance
public class Config {
    static final ResourceLocation EXTRA_LOOT_ID = Registries.getLocation("undead_army/extra_mob_loot");
    private final BooleanConfig availability = new BooleanConfig(true);
    private final BooleanConfig naturalSpawnsOnly = new BooleanConfig(false);
    private final BooleanConfig resetParticipantsKillRequirement = new BooleanConfig(true);
    private final DoubleConfig waveDuration = new DoubleConfig(1200.0, new Range((Number)300.0, (Number)3600.0));
    private final DoubleConfig preparationDuration = new DoubleConfig(10.0, new Range((Number)1.0, (Number)30.0));
    private final DoubleConfig highlightDelay = new DoubleConfig(300.0, new Range((Number)30.0, (Number)3600.0));
    private final DoubleConfig extraSizePerPlayer = new DoubleConfig(0.5, new Range((Number)0.0, (Number)1.0));
    private final IntegerConfig armyRadius = new IntegerConfig(70, new Range((Number)35, (Number)140));
    private final IntegerConfig killRequirement = new IntegerConfig(75, new Range((Number)0, (Number)1000));
    private final IntegerConfig killRequirementFirst = new IntegerConfig(25, new Range((Number)0, (Number)1000));
    private final IntegerConfig killRequirementWarning = new IntegerConfig(3, new Range((Number)0, (Number)1000));
    private final Supplier<WavesDef> wavesDef;

    public Config() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.UNDEAD_ARMY).addConfig((IConfigurable)this.availability.name("is_enabled").comment("Determines whether the Undead Army can spawn in any way.")).addConfig((IConfigurable)this.naturalSpawnsOnly.name("natural_spawns_only").comment("Determines if the undead has to spawn naturally to contribute to the kill_requirement.")).addConfig((IConfigurable)this.waveDuration.name("wave_duration").comment("Duration that players have to defeat a single wave (in seconds).")).addConfig((IConfigurable)this.preparationDuration.name("preparation_duration").comment("Duration before the next wave arrives (in seconds).")).addConfig((IConfigurable)this.highlightDelay.name("highlight_delay").comment("Duration before all mobs will be highlighted (in seconds).")).addConfig((IConfigurable)this.extraSizePerPlayer.name("extra_size_per_player").comment("Extra size ratio per each additional player on multiplayer (0.25 means ~25% bigger army per player).")).addConfig((IConfigurable)this.armyRadius.name("army_radius").comment("Radius, which determines how big is the raid circle (in blocks).")).addConfig((IConfigurable)this.killRequirement.name("kill_requirement").comment("Required amount of killed undead to start the Undead Army. (set to 0 if you want to disable this)")).addConfig((IConfigurable)this.killRequirementFirst.name("kill_requirement_first").comment("Required amount of killed undead to start the first Undead Army.")).addConfig((IConfigurable)this.resetParticipantsKillRequirement.name("reset_participants_kill_requirement").comment("If all participants of an undead army should have their kill count reset (false resets only the person who caused it).")).addConfig((IConfigurable)this.killRequirementWarning.name("kill_requirement_warning").comment("How many left to kill until the undead army warning shows up (set to 0 to disable this)."));
        this.wavesDef = JsonListener.add((String)"custom", (ResourceLocation)Registries.getLocation("undead_army_waves"), WavesDef.class, WavesDef::new);
        OnServerTick.listen(data -> Registries.getUndeadArmyManager().tick()).addCondition(Condition.isEndPhase()).insertTo(group);
        OnDeath.listen(this::updateKilledUndead).addCondition(Condition.predicate(data -> this.getRequiredKills() > 0)).addCondition(Condition.predicate(data -> data.target.m_6336_() == MobType.f_21641_)).addCondition(Condition.predicate(data -> !Registries.getUndeadArmyManager().isPartOfUndeadArmy((Entity)data.target))).addCondition(Condition.predicate(data -> data.attacker instanceof ServerPlayer)).addCondition(Condition.predicate(data -> LevelHelper.isEntityIn((Entity)data.attacker, (ResourceKey)Level.f_46428_))).insertTo(group);
        OnLoot.listen(this::giveExtraLoot).addCondition(Condition.isServer()).addCondition(OnLoot.hasDamageSource()).addCondition(Condition.predicate(data -> !data.context.getQueriedLootTableId().equals((Object)EXTRA_LOOT_ID))).addCondition(Condition.predicate(data -> {
            Mob mob;
            Entity patt6063$temp = data.entity;
            return patt6063$temp instanceof Mob && (mob = (Mob)patt6063$temp).m_6336_() == MobType.f_21641_;
        })).addCondition(Condition.predicate(data -> ExtraLootInfo.hasExtraLootTag(data.entity))).insertTo(group);
    }

    public boolean isEnabled() {
        return this.availability.isEnabled();
    }

    public boolean getNaturalSpawnsOnly() {
        return this.naturalSpawnsOnly.isEnabled();
    }

    public boolean isResetAllParticipantsKillRequirementsEnabled() {
        return this.resetParticipantsKillRequirement.isEnabled();
    }

    public int getWaveDuration() {
        return this.waveDuration.asTicks();
    }

    public int getPreparationDuration() {
        return this.preparationDuration.asTicks();
    }

    public float getSizeMultiplier(int playerCount) {
        return 1.0f + (float)Math.max(playerCount - 1, 0) * this.extraSizePerPlayer.asFloat();
    }

    public int getWavesNum() {
        return this.getWaves().size();
    }

    public int getArmyRadius() {
        return (Integer)this.armyRadius.get();
    }

    public int getHighlightDelay() {
        return this.highlightDelay.asTicks();
    }

    public int getRequiredKills() {
        return (Integer)this.killRequirement.get();
    }

    public int getInitialKillsCount() {
        return (Integer)this.killRequirement.get() - (Integer)this.killRequirementFirst.get();
    }

    public int getSpawnRadius() {
        return this.getArmyRadius() - 15;
    }

    public int getKillRequirementWarning() {
        return (Integer)this.killRequirementWarning.get();
    }

    public WaveDef getWave(int waveIdx) {
        List<WaveDef> waves = this.getWaves();
        return waves.get(Mth.m_14045_((int)(waveIdx - 1), (int)0, (int)(waves.size() - 1)));
    }

    public List<WaveDef> getWaves() {
        return this.wavesDef.get().stream().filter(waveDef -> GameStage.atLeast(waveDef.gameStage)).toList();
    }

    public UndeadArmyInfo readUndeadArmyInfo(CompoundTag tag) {
        return (UndeadArmyInfo)SerializableHelper.read(() -> new UndeadArmyInfo(this.getInitialKillsCount()), (Tag)tag);
    }

    public void modifyUndeadArmyInfo(CompoundTag tag, Consumer<UndeadArmyInfo> consumer) {
        SerializableHelper.modify(() -> new UndeadArmyInfo(this.getInitialKillsCount()), (Tag)tag, consumer);
    }

    private void updateKilledUndead(OnDeath.Data data) {
        ServerPlayer player = (ServerPlayer)data.attacker;
        this.modifyUndeadArmyInfo(player.getPersistentData(), info -> {
            ++info.killedUndead;
            if (info.killedUndead >= this.getRequiredKills() && Registries.getUndeadArmyManager().tryToSpawn((Player)player)) {
                info.killedUndead = 0;
            } else if (this.getKillRequirementWarning() > 0 && info.killedUndead == this.getRequiredKills() - this.getKillRequirementWarning()) {
                player.m_5661_((Component)new TranslatableComponent("majruszsdifficulty.undead_army.warning").m_130940_(ChatFormatting.DARK_PURPLE), false);
            }
        });
    }

    private void giveExtraLoot(OnLoot.Data data) {
        List extraLoot = LootHelper.getLootTable((ResourceLocation)EXTRA_LOOT_ID).m_79129_(this.toExtraLootContext(data));
        data.generatedLoot.addAll(extraLoot);
    }

    private LootContext toExtraLootContext(OnLoot.Data data) {
        return new LootContext.Builder(data.getServerLevel()).m_78972_(LootContextParams.f_81460_, (Object)data.entity.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)data.entity).m_78972_(LootContextParams.f_81457_, (Object)data.damageSource).m_78984_(LootContextParams.f_81458_, (Object)data.killer).m_78975_(LootContextParamSets.f_81415_);
    }
}

