/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebags;

import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.treasurebags.data.LootData;
import com.majruszsdifficulty.treasurebags.data.LootProgressData;
import com.mlib.Utility;
import com.mlib.client.ClientHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class TreasureBagProgressClient {
    static final Map<String, List<Component>> TREASURE_BAG_COMPONENTS = new HashMap<String, List<Component>>();
    static LootProgressData LOOT_PROGRESS_DATA = new LootProgressData();

    public static void handle(Player player, LootProgressData data) {
        TreasureBagProgressClient.generateTextComponents(data);
        if (TreasureBagProgressClient.LOOT_PROGRESS_DATA.treasureBags.size() == data.treasureBags.size()) {
            TreasureBagProgressClient.tryToSendNewLootMessage(player, data);
        }
        LOOT_PROGRESS_DATA = data;
    }

    public static List<Component> getTextComponents(TreasureBagItem item) {
        if (ClientHelper.isShiftDown()) {
            return TREASURE_BAG_COMPONENTS.get(Utility.getRegistryString((Item)item));
        }
        return List.of(new TranslatableComponent("majruszsdifficulty.treasure_bag.hint_tooltip").m_130940_(ChatFormatting.GRAY));
    }

    private static void generateTextComponents(LootProgressData data) {
        for (String treasureBagId : data.treasureBags.keySet()) {
            List<LootData> lootDataList = data.treasureBags.get((Object)treasureBagId).lootDataList;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            lootDataList.forEach(lootData -> tooltip.add(new TextComponent(" ").m_7220_((Component)TreasureBagProgressClient.getTextComponent(lootData))));
            tooltip.add(0, TreasureBagProgressClient.getProgressComponent(lootDataList));
            TREASURE_BAG_COMPONENTS.put(treasureBagId, tooltip);
        }
    }

    private static MutableComponent getTextComponent(LootData lootData) {
        if (lootData.isUnlocked) {
            return ((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(lootData.itemId))).m_41466_().m_6881_().m_130940_(TreasureBagProgressClient.getUnlockedItemFormat(lootData.quality));
        }
        return new TextComponent("???").m_130940_(TreasureBagProgressClient.getLockedItemFormat(lootData.quality));
    }

    private static MutableComponent getProgressComponent(List<LootData> lootDataList) {
        int unlockedItems = (int)lootDataList.stream().filter(data -> data.isUnlocked).count();
        int totalItems = lootDataList.size();
        return new TranslatableComponent("majruszsdifficulty.treasure_bag.list_tooltip", new Object[]{unlockedItems, totalItems}).m_130940_(ChatFormatting.GRAY);
    }

    private static ChatFormatting getUnlockedItemFormat(int quality) {
        return switch (quality) {
            case 4 -> ChatFormatting.GOLD;
            case 3 -> ChatFormatting.LIGHT_PURPLE;
            case 2 -> ChatFormatting.BLUE;
            case 1 -> ChatFormatting.GREEN;
            default -> ChatFormatting.GRAY;
        };
    }

    private static ChatFormatting getLockedItemFormat(int quality) {
        return switch (quality) {
            case 4 -> ChatFormatting.GOLD;
            case 3 -> ChatFormatting.DARK_PURPLE;
            case 2 -> ChatFormatting.BLUE;
            case 1 -> ChatFormatting.DARK_GREEN;
            default -> ChatFormatting.DARK_GRAY;
        };
    }

    private static void tryToSendNewLootMessage(Player player, LootProgressData data) {
        block0: for (String treasureBagId : data.treasureBags.keySet()) {
            List<LootData> lootDataList = data.treasureBags.get((Object)treasureBagId).lootDataList;
            List<LootData> lootDataOldList = TreasureBagProgressClient.LOOT_PROGRESS_DATA.treasureBags.get((Object)treasureBagId).lootDataList;
            if (lootDataList.size() != lootDataOldList.size()) continue;
            for (int i = 0; i < lootDataList.size(); ++i) {
                if (!lootDataList.get((int)i).isUnlocked || lootDataOldList.get((int)i).isUnlocked) continue;
                player.m_5661_((Component)TreasureBagProgressClient.getMessageComponent(treasureBagId, lootDataList, lootDataOldList), false);
                continue block0;
            }
        }
    }

    private static MutableComponent getMessageComponent(String treasureBagId, List<LootData> lootDataList, List<LootData> lootDataOldList) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(treasureBagId));
        if (item instanceof TreasureBagItem) {
            TreasureBagItem treasureBagItem = (TreasureBagItem)item;
            MutableComponent treasureBag = treasureBagItem.m_41466_().m_6881_().m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TreasureBagProgressClient.getHoverComponent(treasureBagId, lootDataList, lootDataOldList))));
            return new TranslatableComponent("majruszsdifficulty.treasure_bag.new_items", new Object[]{ComponentUtils.m_130748_((Component)treasureBag).m_130938_(treasureBagItem.m_41460_(new ItemStack((ItemLike)treasureBagItem)).getStyleModifier())});
        }
        return new TextComponent("ERROR").m_130940_(ChatFormatting.RED);
    }

    private static MutableComponent getHoverComponent(String treasureBagId, List<LootData> lootDataList, List<LootData> lootDataOldList) {
        MutableComponent tooltip = TREASURE_BAG_COMPONENTS.get(treasureBagId).get(0).m_6881_();
        for (int i = 0; i < lootDataList.size(); ++i) {
            tooltip.m_130946_("\n");
            MutableComponent component = TREASURE_BAG_COMPONENTS.get(treasureBagId).get(i + 1).m_6881_();
            if (lootDataList.get((int)i).isUnlocked && !lootDataOldList.get((int)i).isUnlocked) {
                component.m_130940_(ChatFormatting.BOLD);
            }
            tooltip.m_7220_((Component)component);
        }
        return tooltip;
    }
}

