/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebags;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.mlib.Utility;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnDamaged;
import com.mlib.contexts.OnDeath;
import com.mlib.contexts.OnItemFished;
import com.mlib.contexts.OnPlayerTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.data.SerializableStructure;
import com.mlib.items.ItemHelper;
import com.mlib.modhelper.AutoInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;

@AutoInstance
public class TreasureBagManager {
    static final String PARTICIPANT_LIST_TAG = "TreasureBagPlayersToReward";
    static final String PLAYER_TAG = "TreasureBagPlayerUUID";
    static final List<Register> REGISTERS = new ArrayList<Register>();

    public static void addTreasureBagTo(EntityType<?> entityType, TreasureBagItem treasureBag) {
        REGISTERS.add(new Register(entityType, treasureBag));
    }

    @Nullable
    public static TreasureBagItem getTreasureBag(EntityType<?> entityType) {
        Register register = TreasureBagManager.getRegisterFor(entityType);
        return register != null ? register.treasureBag : null;
    }

    public static boolean hasTreasureBag(EntityType<?> entityType) {
        return TreasureBagManager.getRegisterFor(entityType) != null;
    }

    @Nullable
    private static Player getPlayerByUUID(ServerLevel level, CompoundTag tag) {
        return level.m_46003_(UUID.fromString(tag.m_128461_(PLAYER_TAG)));
    }

    @Nullable
    private static Register getRegisterFor(EntityType<?> entityType) {
        for (Register register : REGISTERS) {
            if (!register.entityType.equals(entityType)) continue;
            return register;
        }
        return null;
    }

    public TreasureBagManager() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.TREASURE_BAG).addConfigs((IConfigurable[])TreasureBagItem.getConfigs());
        OnDamaged.listen(this::addPlayerToParticipantList).addCondition(Condition.predicate(data -> data.attacker instanceof Player)).addCondition(Condition.predicate(data -> TreasureBagManager.hasTreasureBag(data.target.m_6095_()))).insertTo(group);
        OnDeath.listen(this::rewardAllParticipants).addCondition(Condition.predicate(data -> TreasureBagManager.hasTreasureBag(data.target.m_6095_()))).addCondition(Condition.predicate(data -> {
            TreasureBagItem treasureBag = TreasureBagManager.getTreasureBag(data.target.m_6095_());
            return treasureBag != null && treasureBag.isEnabled();
        })).insertTo(group);
        OnItemFished.listen(this::giveTreasureBagToAngler).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> {
            CompoundTag tag = data.player.getPersistentData();
            FishingData fishingData = new FishingData();
            fishingData.read((Tag)tag);
            fishingData.fishedItems = (fishingData.fishedItems + 1) % (Integer)TreasureBagItem.Fishing.REQUIRED_FISH_COUNT.getCurrentGameStageValue();
            fishingData.write((Tag)tag);
            return fishingData.fishedItems == 0;
        })).addCondition(Condition.predicate(data -> TreasureBagItem.Fishing.CONFIG.isEnabled())).insertTo(group);
        OnPlayerTick.listen(this::giveTreasureBagToHero).addCondition(Condition.isServer()).addCondition(Condition.cooldown((int)20, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.predicate(data -> TreasureBagItem.Pillager.CONFIG.isEnabled())).addCondition(Condition.predicate(data -> {
            Raid raid = data.getServerLevel().m_8832_(data.player.m_142538_());
            if (raid == null || !raid.m_37767_() || !data.player.m_21023_(MobEffects.f_19595_)) {
                return false;
            }
            CompoundTag tag = data.player.getPersistentData();
            RaidData raidData = new RaidData();
            raidData.read((Tag)tag);
            if (raidData.raidId == raid.m_37781_()) {
                return false;
            }
            raidData.raidId = raid.m_37781_();
            raidData.write((Tag)tag);
            return true;
        })).insertTo(group);
    }

    private void addPlayerToParticipantList(OnDamaged.Data damagedData) {
        Player player = (Player)damagedData.attacker;
        ListTag listNBT = TreasureBagManager.getOrCreateList(damagedData.target);
        CompoundTag playerNBT = TreasureBagManager.createPlayerTag(player);
        if (!TreasureBagManager.isPlayerInList(player, listNBT)) {
            listNBT.add((Object)playerNBT);
            damagedData.target.getPersistentData().m_128365_(PARTICIPANT_LIST_TAG, (Tag)listNBT);
        }
    }

    private static ListTag getOrCreateList(LivingEntity entity) {
        CompoundTag data = entity.getPersistentData();
        return data.m_128441_(PARTICIPANT_LIST_TAG) ? data.m_128437_(PARTICIPANT_LIST_TAG, 10) : new ListTag();
    }

    private static CompoundTag createPlayerTag(Player player) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(PLAYER_TAG, Utility.getPlayerUUID((Player)player));
        return nbt;
    }

    private static boolean isPlayerInList(Player player, ListTag listNBT) {
        String uuid = Utility.getPlayerUUID((Player)player);
        for (int i = 0; i < listNBT.size(); ++i) {
            if (!listNBT.m_128728_(i).m_128461_(PLAYER_TAG).equals(uuid)) continue;
            return true;
        }
        return false;
    }

    private void rewardAllParticipants(OnDeath.Data data) {
        LivingEntity killedEntity = data.target;
        ListTag listNBT = TreasureBagManager.getOrCreateList(killedEntity);
        Level level = data.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (int i = 0; i < listNBT.size(); ++i) {
            TreasureBagManager.giveTreasureBagTo(TreasureBagManager.getPlayerByUUID(level2, listNBT.m_128728_(i)), TreasureBagManager.getTreasureBag(killedEntity.m_6095_()), level2);
        }
        listNBT.clear();
    }

    private static void giveTreasureBagTo(Player player, TreasureBagItem item, ServerLevel level) {
        if (player == null || level == null) {
            return;
        }
        ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((ItemLike)item), (Player)player, (ServerLevel)level);
    }

    private void giveTreasureBagToAngler(OnItemFished.Data fishedData) {
        TreasureBagManager.giveTreasureBagTo(fishedData.player, (TreasureBagItem)((Object)Registries.FISHING_TREASURE_BAG.get()), fishedData.getServerLevel());
    }

    private void giveTreasureBagToHero(OnPlayerTick.Data tickData) {
        TreasureBagManager.giveTreasureBagTo(tickData.player, (TreasureBagItem)((Object)Registries.PILLAGER_TREASURE_BAG.get()), tickData.getServerLevel());
    }

    record Register(EntityType<?> entityType, TreasureBagItem treasureBag) {
    }

    static class RaidData
    extends SerializableStructure {
        int raidId = -1;

        public RaidData() {
            this.defineInteger("TreasureBagLastPillagerRaidID", () -> this.raidId, x -> {
                this.raidId = x;
            });
        }
    }

    static class FishingData
    extends SerializableStructure {
        int fishedItems = 0;

        public FishingData() {
            this.defineInteger("TreasureBagFishingCounter", () -> this.fishedItems, x -> {
                this.fishedItems = x;
            });
        }
    }
}

