/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.contexts.base.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.items.CustomItemTier;
import com.mlib.config.ConfigGroup;
import com.mlib.config.EffectConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnDamaged;
import com.mlib.contexts.OnDeath;
import com.mlib.contexts.OnItemAttributeTooltip;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.data.SerializableHelper;
import com.mlib.data.SerializableStructure;
import com.mlib.effects.ParticleHandler;
import com.mlib.entities.EntityHelper;
import com.mlib.items.ItemHelper;
import com.mlib.mobeffects.MobEffectHelper;
import com.mlib.modhelper.AutoInstance;
import com.mlib.text.TextHelper;
import com.mlib.time.Time;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WitherSwordItem
extends SwordItem {
    static final String GROUP_ID = Registries.getLocationString("wither_sword");

    public WitherSwordItem() {
        super((Tier)CustomItemTier.WITHER, 3, -2.4f, new Item.Properties().m_41491_(Registries.ITEM_GROUP).m_41497_(Rarity.UNCOMMON));
    }

    static {
        ModConfigs.init((String)Registries.Groups.DEFAULT, (String)GROUP_ID).name("WitherSword");
    }

    @AutoInstance
    public static class TurnSkeletonIntoWitherSkeleton {
        public TurnSkeletonIntoWitherSkeleton() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)GROUP_ID).name("TransformSkeletons").comment("If the Skeleton dies from Wither Sword it will respawn as Wither Skeleton in a few seconds.");
            OnDamaged.listen(this::applyWitherTag).addCondition(Condition.predicate(data -> data.attacker != null)).addCondition(Condition.predicate(data -> data.attacker.m_21205_().m_41720_() instanceof WitherSwordItem)).addCondition(Condition.predicate(data -> data.target instanceof Skeleton)).insertTo(group);
            OnDeath.listen(this::spawnWitherSkeleton).addCondition(Condition.isServer()).addCondition(CustomConditions.gameStageAtLeast(GameStage.MASTER)).addCondition(Condition.chanceCRD((double)0.5, (boolean)true)).addCondition(Condition.excludable()).addCondition(Condition.predicate(data -> ((Data)SerializableHelper.read((Supplier<Data>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/majruszsdifficulty/items/WitherSwordItem$TurnSkeletonIntoWitherSkeleton$Data;)(), (Tag)data.target.getPersistentData())).hasWitherTag)).insertTo(group);
        }

        private void applyWitherTag(OnDamaged.Data data) {
            SerializableHelper.modify(Data::new, (Tag)data.target.getPersistentData(), subdata -> {
                subdata.hasWitherTag = true;
            });
        }

        private void spawnWitherSkeleton(OnDeath.Data data) {
            ServerLevel level = data.getServerLevel();
            Time.slider((double)7.0, slider -> {
                Vec3 position = data.target.m_20182_().m_82520_(0.0, 1.0, 0.0);
                if (slider.getTicksLeft() % 5 == 0) {
                    ParticleHandler.SOUL.spawn(level, position, (int)(slider.getRatio() * 10.0f), ParticleHandler.offset((float)slider.getRatio()));
                }
                if (slider.getTicksLeft() == 2) {
                    ParticleHandler.SOUL.spawn(level, position, 100, ParticleHandler.offset((float)0.5f));
                    ParticleHandler.SOUL.spawn(level, position, 100, ParticleHandler.offset((float)1.0f));
                }
                if (slider.isFinished()) {
                    EntityHelper.createSpawner((EntityType)EntityType.f_20497_, (Level)level).mobSpawnType(MobSpawnType.EVENT).position(data.target.m_20182_()).spawn();
                }
            });
        }

        private static class Data
        extends SerializableStructure {
            boolean hasWitherTag = false;

            public Data() {
                this.defineBoolean("MajruszsDifficultyWitherTag", () -> this.hasWitherTag, x -> {
                    this.hasWitherTag = x;
                });
            }
        }
    }

    @AutoInstance
    public static class Effect {
        static final String ATTRIBUTE_ID = "item.majruszsdifficulty.wither_sword.effect";
        final EffectConfig wither = new EffectConfig(MobEffects.f_19615_, 1, 6.0);

        public Effect() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)GROUP_ID).name("Effect").comment("Wither Sword inflicts wither effect.");
            OnDamaged.listen(this::applyWither).addCondition(Condition.predicate(data -> ItemHelper.hasInMainHand((LivingEntity)data.attacker, (Class[])new Class[]{WitherSwordItem.class}))).addCondition(Condition.predicate(data -> data.source.m_7640_() == data.attacker)).addConfig((IConfigurable)this.wither).insertTo(group);
            OnItemAttributeTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.item instanceof WitherSwordItem)).insertTo(group);
        }

        private void applyWither(OnDamaged.Data data) {
            MobEffectHelper.tryToApply((LivingEntity)data.target, (MobEffect)MobEffects.f_19615_, (int)this.wither.getDuration(), (int)this.wither.getAmplifier());
        }

        private void addTooltip(OnItemAttributeTooltip.Data data) {
            String chance = TextHelper.percent((float)1.0f);
            String amplifier = TextHelper.toRoman((int)(this.wither.getAmplifier() + 1));
            data.add(EquipmentSlot.MAINHAND, (Component)new TranslatableComponent(ATTRIBUTE_ID, new Object[]{chance, amplifier}).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }
}

