/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.contexts.OnSoulJarMultiplier;
import com.mlib.attributes.AttributeHandler;
import com.mlib.contexts.OnBreakSpeed;
import com.mlib.contexts.OnItemAttributeTooltip;
import com.mlib.contexts.OnItemEquipped;
import com.mlib.contexts.OnItemTooltip;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.OnPreDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.data.SerializableHelper;
import com.mlib.data.SerializableStructure;
import com.mlib.effects.SoundHandler;
import com.mlib.modhelper.AutoInstance;
import com.mlib.text.TextHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.DistExecutor;

public class SoulJarItem
extends Item {
    static final float DAMAGE_BONUS = 2.5f;
    static final float MOVE_BONUS = 0.15f;
    static final float RANGE_BONUS = 0.5f;
    static final int ARMOR_BONUS = 3;
    static final float MINE_BONUS = 0.15f;
    static final int LUCK_BONUS = 1;
    static final float SWIM_BONUS = 0.3f;

    public static ItemStack randomItemStack(int bonusCount) {
        ItemStack itemStack = new ItemStack((ItemLike)Registries.SOUL_JAR.get());
        SerializableHelper.modify(BonusInfo::new, (Tag)itemStack.m_41784_(), info -> {
            info.bonusCount = bonusCount;
        });
        return itemStack;
    }

    public SoulJarItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON).m_41491_(Registries.ITEM_GROUP));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        BonusInfo bonusInfo = (BonusInfo)SerializableHelper.read(BonusInfo::new, (Tag)itemStack.m_41784_());
        if (bonusInfo.bonusMask == 0) {
            if (level instanceof ServerLevel) {
                bonusInfo.randomize();
                bonusInfo.write((Tag)itemStack.m_41784_());
                SoundHandler.ENCHANT.play(level, player.m_20182_());
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public static class BonusInfo
    extends SerializableStructure {
        public int bonusMask = 0;
        public int bonusCount = 3;

        public BonusInfo() {
            super("SoulJar");
            this.defineInteger("BonusMask", () -> this.bonusMask, x -> {
                this.bonusMask = x;
            });
            this.defineInteger("BonusCount", () -> this.bonusCount, x -> {
                this.bonusCount = x;
            });
        }

        public void randomize() {
            this.bonusMask = 0;
            ArrayList<BonusType> bonusTypes = new ArrayList<BonusType>(Arrays.stream(BonusType.values()).toList());
            Collections.shuffle(bonusTypes);
            bonusTypes.stream().limit(this.bonusCount).forEach(bonusType -> this.bonusMask |= bonusType.bit);
        }

        public boolean hasBonuses() {
            return this.bonusMask != 0;
        }

        public List<BonusType> getBonusTypes() {
            return Arrays.stream(BonusType.values()).filter(bonusType -> (bonusType.bit & this.bonusMask) != 0).toList();
        }

        public List<Component> getHintComponents() {
            ArrayList<Component> components = new ArrayList<Component>();
            if (this.bonusMask == 0) {
                MutableComponent bonusCount = new TextComponent("" + this.bonusCount).m_130940_(ChatFormatting.GREEN);
                components.add((Component)new TranslatableComponent("item.majruszsdifficulty.soul_jar.item_tooltip1", new Object[]{bonusCount}).m_130940_(ChatFormatting.GRAY));
                components.add((Component)new TranslatableComponent("item.majruszsdifficulty.soul_jar.item_tooltip2").m_130940_(ChatFormatting.GRAY));
            } else {
                components.add((Component)new TranslatableComponent("item.majruszsdifficulty.soul_jar.item_tooltip3").m_130940_(ChatFormatting.GRAY));
            }
            return components;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        static final Map<BonusType, Integer> COLOR_MAPPING = Map.of(BonusType.DAMAGE, 0xCC5555, BonusType.MOVE, 0xDDDDDD, BonusType.RANGE, 0xCC55CC, BonusType.ARMOR, 0x5555CC, BonusType.MINE, 0xCCCC55, BonusType.LUCK, 0x55CC55, BonusType.SWIM, 0x55CCCC);

        public int m_92671_(ItemStack itemStack, int index) {
            if (index == 0) {
                return 0xFFFFFF;
            }
            BonusInfo bonusInfo = (BonusInfo)SerializableHelper.read(BonusInfo::new, (Tag)itemStack.m_41784_());
            return bonusInfo.hasBonuses() ? COLOR_MAPPING.get((Object)bonusInfo.getBonusTypes().get(index - 1)) : 0xEEEEEE - index * 0x111111;
        }
    }

    public static enum BonusType {
        DAMAGE(1, "item.majruszsdifficulty.soul_jar.smite", "entity.minecraft.wolf", ChatFormatting.RED, multiplier -> TextHelper.signed((float)(2.5f * multiplier.floatValue()))),
        MOVE(2, "item.majruszsdifficulty.soul_jar.move", "entity.minecraft.horse", ChatFormatting.WHITE, multiplier -> TextHelper.signedPercent((float)(0.15f * multiplier.floatValue()))),
        RANGE(4, "item.majruszsdifficulty.soul_jar.range", "entity.minecraft.enderman", ChatFormatting.DARK_PURPLE, multiplier -> TextHelper.signed((float)(0.5f * multiplier.floatValue()))),
        ARMOR(8, "item.majruszsdifficulty.soul_jar.armor", "entity.majruszsdifficulty.tank", ChatFormatting.BLUE, multiplier -> TextHelper.signed((int)((int)(3.0f * multiplier.floatValue())))),
        MINE(16, "item.majruszsdifficulty.soul_jar.mine", "entity.minecraft.sniffer", ChatFormatting.YELLOW, multiplier -> TextHelper.signedPercent((float)(0.15f * multiplier.floatValue()))),
        LUCK(32, "item.majruszsdifficulty.soul_jar.luck", "entity.minecraft.rabbit", ChatFormatting.GREEN, multiplier -> TextHelper.signed((int)((int)(1.0f * multiplier.floatValue())))),
        SWIM(64, "item.majruszsdifficulty.soul_jar.swim", "entity.minecraft.dolphin", ChatFormatting.AQUA, multiplier -> TextHelper.signedPercent((float)(0.3f * multiplier.floatValue())));

        final int bit;
        final String bonusId;
        final String mobId;
        final ChatFormatting soulFormatting;
        final Function<Float, String> valueProvider;

        private BonusType(int bit, String bonusId, String mobId, ChatFormatting soulFormatting, Function<Float, String> valueProvider) {
            this.bit = bit;
            this.bonusId = bonusId;
            this.mobId = mobId;
            this.soulFormatting = soulFormatting;
            this.valueProvider = valueProvider;
        }

        public Component getBonusComponent(float multiplier) {
            return new TranslatableComponent(this.bonusId, new Object[]{this.valueProvider.apply(Float.valueOf(multiplier))}).m_130940_(ChatFormatting.BLUE);
        }

        public Component getSoulComponent() {
            return new TranslatableComponent(this.mobId).m_130940_(this.soulFormatting);
        }
    }

    @AutoInstance
    public static class Handler {
        public Handler() {
            OnItemEquipped.listen(this::updateAttributes).addCondition(Condition.predicate(data -> data.entity instanceof LivingEntity));
            OnPreDamaged.listen(this::increaseDamage).addCondition(Condition.predicate(data -> {
                Mob mob;
                LivingEntity patt3244$temp = data.target;
                return patt3244$temp instanceof Mob && (mob = (Mob)patt3244$temp).m_6336_() == MobType.f_21641_;
            })).addCondition(Condition.predicate(data -> data.attacker != null)).addCondition(Condition.predicate(data -> Handler.hasBonus((Entity)data.attacker, BonusType.DAMAGE)));
            OnBreakSpeed.listen(this::increaseSpeed).addCondition(Condition.predicate(data -> Handler.hasBonus((Entity)data.player, BonusType.MINE)));
            OnLoot.listen(this::applyRandomSouls).addCondition(Condition.isServer());
            OnItemAttributeTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.itemStack.m_41720_() instanceof SoulJarItem));
            OnItemTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.itemStack.m_41720_() instanceof SoulJarItem));
        }

        private static boolean hasBonus(@Nullable Entity entity, BonusType bonusType) {
            ItemStack itemStack;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                v0 = livingEntity.m_6844_(EquipmentSlot.OFFHAND);
            } else {
                v0 = itemStack = ItemStack.f_41583_;
            }
            if (!(itemStack.m_41720_() instanceof SoulJarItem)) {
                return false;
            }
            return ((BonusInfo)SerializableHelper.read(BonusInfo::new, (Tag)itemStack.m_41784_())).getBonusTypes().contains((Object)bonusType);
        }

        private static float getMultiplier(@Nullable Entity entity, ItemStack itemStack) {
            if (!(itemStack.m_41720_() instanceof SoulJarItem)) {
                return 0.0f;
            }
            return OnSoulJarMultiplier.dispatch(entity, itemStack).getMultiplier();
        }

        private static float getMultiplier(@Nullable Entity entity) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = Handler.getMultiplier(entity, livingEntity.m_6844_(EquipmentSlot.OFFHAND));
            } else {
                f = 0.0f;
            }
            return f;
        }

        private void updateAttributes(OnItemEquipped.Data data) {
            LivingEntity entity = data.entity;
            float multiplier = Handler.getMultiplier((Entity)entity);
            float moveBonus = Handler.hasBonus((Entity)data.entity, BonusType.MOVE) ? 0.15f : 0.0f;
            float armorBonus = Handler.hasBonus((Entity)data.entity, BonusType.ARMOR) ? 3.0f : 0.0f;
            float rangeBonus = Handler.hasBonus((Entity)data.entity, BonusType.RANGE) ? 0.5f : 0.0f;
            float luckBonus = Handler.hasBonus((Entity)data.entity, BonusType.LUCK) ? 1.0f : 0.0f;
            float swimBonus = Handler.hasBonus((Entity)data.entity, BonusType.SWIM) ? 0.3f : 0.0f;
            AttributeHandler MOVE_ATTRIBUTE = new AttributeHandler("51e7e4fb-e8b4-4c90-ab8a-e8c334e206be", "SoulJarMovementBonus", Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
            AttributeHandler ARMOR_ATTRIBUTE = new AttributeHandler("7d2d7767-51da-46cc-8081-80fda32d4126", "SoulJarArmorBonus", Attributes.f_22284_, AttributeModifier.Operation.ADDITION);
            AttributeHandler REACH_ATTRIBUTE = new AttributeHandler("23868877-961b-44c9-89c3-376e5c06dbd1", "SoulJarReachBonus", (Attribute)ForgeMod.REACH_DISTANCE.get(), AttributeModifier.Operation.ADDITION);
            AttributeHandler RANGE_ATTRIBUTE = new AttributeHandler("a45d6f34-5b78-4d7c-b60a-03fe6400f8cd", "SoulJarRangeBonus", (Attribute)ForgeMod.ATTACK_RANGE.get(), AttributeModifier.Operation.ADDITION);
            AttributeHandler LUCK_ATTRIBUTE = new AttributeHandler("a2a496f4-3799-46eb-856c-1ba992f67912", "SoulJarLuckBonus", Attributes.f_22286_, AttributeModifier.Operation.ADDITION);
            AttributeHandler SWIM_ATTRIBUTE = new AttributeHandler("f404c216-a758-404f-ba95-5a53d3974b44", "SoulJarSwimmingBonus", (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
            MOVE_ATTRIBUTE.setValue((double)(multiplier * moveBonus)).apply(entity);
            ARMOR_ATTRIBUTE.setValue((double)(multiplier * armorBonus)).apply(entity);
            REACH_ATTRIBUTE.setValue((double)(multiplier * rangeBonus)).apply(entity);
            RANGE_ATTRIBUTE.setValue((double)(multiplier * rangeBonus)).apply(entity);
            LUCK_ATTRIBUTE.setValue((double)(multiplier * luckBonus)).apply(entity);
            SWIM_ATTRIBUTE.setValue((double)(multiplier * swimBonus)).apply(entity);
        }

        private void increaseDamage(OnPreDamaged.Data data) {
            data.extraDamage += 6.25f * Handler.getMultiplier((Entity)data.attacker);
            data.spawnMagicParticles = true;
        }

        private void increaseSpeed(OnBreakSpeed.Data data) {
            data.newSpeed *= 1.0f + 0.15f * Handler.getMultiplier((Entity)data.player);
        }

        private void applyRandomSouls(OnLoot.Data data) {
            for (ItemStack itemStack : data.generatedLoot) {
                if (!(itemStack.m_41720_() instanceof SoulJarItem)) continue;
                SerializableHelper.modify(BonusInfo::new, (Tag)itemStack.m_41784_(), bonusInfo -> {
                    if (bonusInfo.bonusMask == 0) {
                        bonusInfo.randomize();
                    }
                });
            }
        }

        private void addTooltip(OnItemAttributeTooltip.Data data) {
            Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
            BonusInfo bonusInfo = (BonusInfo)SerializableHelper.read(BonusInfo::new, (Tag)data.itemStack.m_41784_());
            float multiplier = Handler.getMultiplier((Entity)player, data.itemStack);
            for (BonusType bonusType : bonusInfo.getBonusTypes()) {
                data.add(EquipmentSlot.OFFHAND, bonusType.getBonusComponent(multiplier));
            }
        }

        private void addTooltip(OnItemTooltip.Data data) {
            BonusInfo bonusInfo = (BonusInfo)SerializableHelper.read(BonusInfo::new, (Tag)data.itemStack.m_41784_());
            if (bonusInfo.hasBonuses()) {
                TextComponent souls = new TextComponent("");
                for (BonusType bonusType : bonusInfo.getBonusTypes()) {
                    souls.m_130946_(souls.getString().equals("") ? "" : " ").m_7220_(bonusType.getSoulComponent());
                }
                data.tooltip.add(1, souls);
            }
            data.tooltip.addAll(1, bonusInfo.getHintComponents());
        }
    }
}

