/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.mlib.Utility;
import com.mlib.effects.SoundHandler;
import com.mlib.items.ItemHelper;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public abstract class ScrollItem
extends Item {
    public static final int MIN_DURATION = Utility.secondsToTicks((double)1.0);

    public ScrollItem() {
        super(new Item.Properties().m_41491_(Registries.ITEM_GROUP).m_41497_(Rarity.UNCOMMON).m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        this.playSound(this::getPrepareSound, level, (LivingEntity)player, 1.0f);
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity entity) {
        this.useScroll(itemStack, level, entity, 1.0f);
        return itemStack;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int ticksLeft) {
        if (this.m_8105_(itemStack) - ticksLeft < MIN_DURATION) {
            this.disableItem(itemStack, entity, Utility.secondsToTicks((double)1.0));
            return;
        }
        float useRatio = Mth.m_14036_((float)(1.0f - (float)ticksLeft / (float)(this.m_8105_(itemStack) - MIN_DURATION)), (float)0.0f, (float)1.0f);
        this.useScroll(itemStack, level, entity, useRatio);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack itemStack) {
        return Utility.secondsToTicks((double)3.0);
    }

    protected void useScroll(ItemStack itemStack, Level level, LivingEntity entity, float useRatio) {
        this.disableItem(itemStack, entity, Utility.secondsToTicks((double)16.0));
        this.playSound(this::getCastSound, level, entity, 2.0f);
    }

    protected void playSound(Supplier<SoundEvent> sound, Level level, LivingEntity entity, float volumeScale) {
        new SoundHandler(sound.get(), SoundSource.PLAYERS, SoundHandler.randomized((float)volumeScale)).play(level, entity.m_20182_());
    }

    protected void disableItem(ItemStack itemStack, LivingEntity entity, int ticks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemHelper.addCooldown((Player)player, (int)ticks, (Item[])new Item[]{itemStack.m_41720_()});
        }
    }

    protected abstract SoundEvent getPrepareSound();

    protected abstract SoundEvent getCastSound();
}

