/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.items.ScrollItem;
import com.mlib.contexts.OnItemAttributeTooltip;
import com.mlib.contexts.OnPreDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.data.SerializableHelper;
import com.mlib.data.SerializableStructure;
import com.mlib.entities.EntityHelper;
import com.mlib.levels.LevelHelper;
import com.mlib.math.AnyPos;
import com.mlib.math.AnyRot;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EvokerFangScrollItem
extends ScrollItem {
    public static int ATTACK_DAMAGE = 12;
    public static Range<Integer> ATTACK_RANGE = new Range((Number)8, (Number)20);

    @Override
    protected void useScroll(ItemStack itemStack, Level level, LivingEntity entity, float useRatio) {
        super.useScroll(itemStack, level, entity, useRatio);
        double rotation = Math.toRadians(entity.m_146908_()) - 1.5707963267948966;
        this.getAttackPattern(entity, (int)Mth.m_14179_((float)useRatio, (float)((Integer)EvokerFangScrollItem.ATTACK_RANGE.from).intValue(), (float)((Integer)EvokerFangScrollItem.ATTACK_RANGE.to).intValue())).forEach(spawnPoint -> {
            EvokerFangs evokerFangs = new EvokerFangs(level, spawnPoint.pos.f_82479_, spawnPoint.pos.f_82480_, spawnPoint.pos.f_82481_, (float)rotation, spawnPoint.cooldown, entity);
            SerializableHelper.modify(DamageInfo::new, (Tag)evokerFangs.getPersistentData(), damageInfo -> {
                damageInfo.extraDamage = (int)((float)ATTACK_DAMAGE - 6.0f);
            });
            level.m_7967_((Entity)evokerFangs);
        });
    }

    @Override
    protected SoundEvent getPrepareSound() {
        return SoundEvents.f_11868_;
    }

    @Override
    protected SoundEvent getCastSound() {
        return SoundEvents.f_11862_;
    }

    private List<SpawnPoint> getAttackPattern(LivingEntity entity, int attackLength) {
        ArrayList<SpawnPoint> spawnPoints = new ArrayList<SpawnPoint>();
        AnyRot lookRotation = EntityHelper.getLookRotation((Entity)entity);
        for (int x = 0; x <= attackLength; ++x) {
            for (int z = -1; z <= 1; ++z) {
                int cooldown = Math.abs(x) + 4;
                Vec3 position = AnyPos.from((Vec3)entity.m_20182_()).floor().add(AnyPos.from((Number)x, (Number)0, (Number)z).rot(lookRotation).round()).vec3();
                LevelHelper.findBlockPosOnGround((Level)entity.f_19853_, (Number)position.f_82479_, (Range)new Range((Number)(position.f_82480_ - 3.0), (Number)(position.f_82480_ + 3.0)), (Number)position.f_82481_).ifPresent(blockPos -> spawnPoints.add(new SpawnPoint(AnyPos.from((BlockPos)blockPos).add((Number)0.5, (Number)0.0, (Number)0.5).vec3(), cooldown)));
            }
        }
        return spawnPoints;
    }

    private record SpawnPoint(Vec3 pos, int cooldown) {
    }

    private static class DamageInfo
    extends SerializableStructure {
        int extraDamage = 0;

        public DamageInfo() {
            this.defineInteger("MajruszsProgressiveDifficultyEvokerFangDamage", () -> this.extraDamage, x -> {
                this.extraDamage = x;
            });
        }
    }

    @AutoInstance
    public static class Tooltip {
        public Tooltip() {
            OnItemAttributeTooltip.listen(this::addSpellInfo).addCondition(Condition.predicate(data -> Registries.EVOKER_FANG_SCROLL.isPresent())).addCondition(Condition.predicate(data -> data.itemStack.m_150930_((Item)Registries.EVOKER_FANG_SCROLL.get())));
        }

        private void addSpellInfo(OnItemAttributeTooltip.Data data) {
            List.of(new TranslatableComponent("majruszsdifficulty.scrolls.attack_damage", new Object[]{ATTACK_DAMAGE}).m_130940_(ChatFormatting.DARK_GREEN), new TranslatableComponent("majruszsdifficulty.scrolls.attack_range", new Object[]{"%d-%d".formatted(EvokerFangScrollItem.ATTACK_RANGE.from, EvokerFangScrollItem.ATTACK_RANGE.to)}).m_130940_(ChatFormatting.DARK_GREEN)).forEach(component -> data.add(EquipmentSlot.MAINHAND, (Component)component));
        }
    }

    @AutoInstance
    public static class Spell {
        public Spell() {
            OnPreDamaged.listen(this::increaseDamage).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.source.m_7640_() instanceof EvokerFangs)).addCondition(OnPreDamaged.dealtAnyDamage());
        }

        private void increaseDamage(OnPreDamaged.Data data) {
            DamageInfo damageInfo = (DamageInfo)SerializableHelper.read(DamageInfo::new, (Tag)data.source.m_7640_().getPersistentData());
            data.extraDamage += (float)damageInfo.extraDamage;
        }
    }
}

