/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamestage.handlers;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.StageProgressConfig;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.config.ConfigGroup;
import com.mlib.config.EnumConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnDeath;
import com.mlib.contexts.OnDimensionChanged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.modhelper.AutoInstance;
import net.minecraft.world.entity.EntityType;

@AutoInstance
public class GameStageIncreaser {
    static final EnumConfig<GameStage> DEFAULT_GAME_STAGE = new EnumConfig((Enum)GameStage.NORMAL);
    final StageProgressConfig expertMode = new StageProgressConfig("", "{regex}.*");
    final StageProgressConfig masterMode = new StageProgressConfig("minecraft:ender_dragon", "");

    public static GameStage getDefaultGameStage() {
        return (GameStage)((Object)DEFAULT_GAME_STAGE.get());
    }

    public GameStageIncreaser() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.GAME_STAGE).addConfig((IConfigurable)DEFAULT_GAME_STAGE.name("default_mode").comment("Game stage set at the beginning of a new world.")).addConfig((IConfigurable)this.expertMode.name("ExpertMode").comment("Determines what starts the Expert Mode.")).addConfig((IConfigurable)this.masterMode.name("MasterMode").comment("Determines what starts the Master Mode."));
        OnDimensionChanged.listen(this::startExpertMode).addCondition(Condition.predicate(data -> GameStage.getCurrentStage() == GameStage.NORMAL)).addCondition(Condition.predicate(data -> this.expertMode.dimensionTriggersChange(data.to.m_135782_()))).insertTo(group);
        OnDimensionChanged.listen(this::startMasterMode).addCondition(Condition.predicate(data -> GameStage.getCurrentStage() == GameStage.EXPERT)).addCondition(Condition.predicate(data -> this.masterMode.dimensionTriggersChange(data.to.m_135782_()))).insertTo(group);
        OnDeath.listen(this::startExpertMode).addCondition(Condition.predicate(data -> GameStage.getCurrentStage() == GameStage.NORMAL)).addCondition(Condition.predicate(data -> this.expertMode.entityTriggersChange(EntityType.m_20613_((EntityType)data.target.m_6095_())))).insertTo(group);
        OnDeath.listen(this::startMasterMode).addCondition(Condition.predicate(data -> GameStage.getCurrentStage() == GameStage.EXPERT)).addCondition(Condition.predicate(data -> this.masterMode.entityTriggersChange(EntityType.m_20613_((EntityType)data.target.m_6095_())))).insertTo(group);
    }

    private void startExpertMode(OnDimensionChanged.Data data) {
        GameStage.changeStage(GameStage.EXPERT, data.entity.m_20194_());
    }

    private void startExpertMode(OnDeath.Data data) {
        GameStage.changeStage(GameStage.EXPERT, data.target.m_20194_());
    }

    private void startMasterMode(OnDimensionChanged.Data data) {
        GameStage.changeStage(GameStage.MASTER, data.entity.m_20194_());
    }

    private void startMasterMode(OnDeath.Data data) {
        GameStage.changeStage(GameStage.MASTER, data.target.m_20194_());
    }
}

