/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features.groups;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.MobGroupConfig;
import com.majruszsdifficulty.contexts.base.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnSpawned;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.levels.LevelHelper;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Zombie;

@AutoInstance
public class ZombiesInGroup
implements Supplier<MobGroupConfig> {
    final MobGroupConfig mobGroups = new MobGroupConfig(() -> EntityType.f_20501_, (Range<Integer>)new Range((Number)1, (Number)3), Registries.getLocation("mob_groups/zombie_leader"), Registries.getLocation("mob_groups/zombie_sidekick"));

    public ZombiesInGroup() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("ZombiesInGroup").comment("Zombies may spawn in groups as miners (only underground).");
        OnSpawned.listenSafe(this::spawnGroup).addCondition(CustomConditions.gameStageAtLeast(GameStage.EXPERT)).addCondition(Condition.chanceCRD((double)0.25, (boolean)true)).addCondition(CustomConditions.isNotPartOfGroup(data -> data.target)).addCondition(CustomConditions.isNotPartOfUndeadArmy(data -> data.target)).addCondition(Condition.isServer()).addCondition(Condition.excludable()).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(OnSpawned.is((Class[])new Class[]{Zombie.class})).addCondition(Condition.predicate(data -> !LevelHelper.isEntityOutside((Entity)data.target) && data.target.m_20182_().f_82480_ < 50.0)).addConfig((IConfigurable)this.mobGroups.name("Zombies")).insertTo(group);
    }

    @Override
    public MobGroupConfig get() {
        return this.mobGroups;
    }

    private void spawnGroup(OnSpawned.Data data) {
        this.mobGroups.spawn((PathfinderMob)data.target);
    }
}

