/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features.groups;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.MobGroupConfig;
import com.majruszsdifficulty.contexts.base.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnSpawned;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Skeleton;

@AutoInstance
public class SkeletonsInGroup
implements Supplier<MobGroupConfig> {
    final MobGroupConfig mobGroups = new MobGroupConfig(() -> EntityType.f_20524_, (Range<Integer>)new Range((Number)1, (Number)3), Registries.getLocation("mob_groups/skeleton_leader"), Registries.getLocation("mob_groups/skeleton_sidekick"));

    public SkeletonsInGroup() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("SkeletonsInGroup").comment("Skeletons may spawn in groups.");
        OnSpawned.listenSafe(this::spawnGroup).addCondition(CustomConditions.gameStageAtLeast(GameStage.EXPERT)).addCondition(Condition.chanceCRD((double)0.1, (boolean)true)).addCondition(CustomConditions.isNotPartOfGroup(data -> data.target)).addCondition(CustomConditions.isNotPartOfUndeadArmy(data -> data.target)).addCondition(Condition.excludable()).addCondition(Condition.isServer()).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(OnSpawned.is((Class[])new Class[]{Skeleton.class})).addConfig((IConfigurable)this.mobGroups.name("Skeletons")).insertTo(group);
    }

    @Override
    public MobGroupConfig get() {
        return this.mobGroups;
    }

    private void spawnGroup(OnSpawned.Data data) {
        this.mobGroups.spawn((PathfinderMob)data.target);
    }
}

