/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features.bleeding;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.contexts.OnBleedingCheck;
import com.majruszsdifficulty.contexts.OnBleedingTooltip;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.OnDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.data.ISerializable;
import com.mlib.data.JsonListener;
import com.mlib.data.SerializableList;
import com.mlib.data.SerializableStructure;
import com.mlib.items.ItemHelper;
import com.mlib.modhelper.AutoInstance;
import com.mlib.text.RegexString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

@AutoInstance
public class ToolsBleeding {
    final BooleanConfig availability = Condition.DefaultConfigs.excludable((boolean)true);
    final JsonListener.Holder<ToolsDef> toolsDef = JsonListener.add((String)"custom", (ResourceLocation)Registries.getLocation("bleeding_tools"), ToolsDef.class, ToolsDef::new).syncWithClients(Registries.HELPER);

    public ToolsBleeding() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.BLEEDING).name("Tools").comment("Various items may inflict bleeding (configurable via data pack).");
        OnBleedingCheck.listen(OnBleedingCheck.Data::trigger).addCondition(Condition.excludable((BooleanConfig)this.availability)).addCondition(Condition.isLivingBeing(data -> data.target)).addCondition(Condition.predicate(OnDamaged.Data::isDirect)).addCondition(ToolsBleeding.tryItemChance(this.toolsDef)).insertTo(group);
        OnBleedingTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> this.availability.isEnabled())).addCondition(Condition.predicate(data -> ((ToolsDef)this.toolsDef.get()).find(data.itemStack).isPresent())).insertTo(group);
    }

    private void addTooltip(OnBleedingTooltip.Data data) {
        data.addItem(((ToolsDef)this.toolsDef.get()).find(data.itemStack).orElseThrow().getChance(data.itemStack));
    }

    private static Condition<OnBleedingCheck.Data> tryItemChance(Supplier<ToolsDef> toolsDef) {
        return Condition.predicate(data -> {
            if (data.attacker == null) {
                return false;
            }
            ItemStack itemStack = data.attacker.m_21205_();
            Optional<ToolDef> toolDef = ((ToolsDef)((Object)((Object)toolsDef.get()))).find(itemStack);
            return toolDef.isPresent() && Random.tryChance((double)toolDef.get().getChance(itemStack));
        });
    }

    public static class ToolsDef
    extends SerializableList {
        public List<ToolDef> toolDefs = new ArrayList<ToolDef>();

        public ToolsDef() {
            this.defineCustom(() -> this.toolDefs, x -> {
                this.toolDefs = x;
            }, ToolDef::new);
        }

        public Optional<ToolDef> find(ItemStack itemStack) {
            return this.toolDefs.stream().filter(toolDef -> toolDef.matches(itemStack)).findFirst();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onClient(NetworkEvent.Context context) {
            Registries.HELPER.findInstance(ToolsBleeding.class).ifPresent(instance -> instance.toolsDef.onSync((ISerializable)this));
        }
    }

    public static class ToolDef
    extends SerializableStructure {
        public RegexString id = new RegexString();
        public float chance;
        public List<EnchantmentDef> enchantmentDefs = new ArrayList<EnchantmentDef>();

        public ToolDef() {
            this.defineString("id", () -> ((RegexString)this.id).get(), arg_0 -> ((RegexString)this.id).set(arg_0));
            this.defineFloat("chance", () -> Float.valueOf(this.chance), x -> {
                this.chance = x.floatValue();
            });
            this.defineCustom("enchantments", () -> this.enchantmentDefs, x -> {
                this.enchantmentDefs = x;
            }, EnchantmentDef::new);
        }

        public float getChance(ItemStack itemStack) {
            return this.chance + ItemHelper.getEnchantmentsInfo((ItemStack)itemStack).enchantments.stream().map(this::getExtraChance).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        }

        public boolean matches(ItemStack itemStack) {
            return this.id.matches(Utility.getRegistryString((Item)itemStack.m_41720_()));
        }

        private float getExtraChance(ItemHelper.EnchantmentInfo enchantmentInfo) {
            for (EnchantmentDef enchantmentDef : this.enchantmentDefs) {
                if (!enchantmentDef.id.matches(enchantmentInfo.id)) continue;
                return (float)enchantmentInfo.level * enchantmentDef.chance;
            }
            return 0.0f;
        }
    }

    public static class EnchantmentDef
    extends SerializableStructure {
        public RegexString id = new RegexString();
        public float chance;

        public EnchantmentDef() {
            this.defineString("id", () -> ((RegexString)this.id).get(), arg_0 -> ((RegexString)this.id).set(arg_0));
            this.defineFloat("extra_chance", () -> Float.valueOf(this.chance), x -> {
                this.chance = x.floatValue();
            });
        }
    }
}

