/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features.bleeding;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.contexts.OnBleedingCheck;
import com.majruszsdifficulty.contexts.OnBleedingTooltip;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.contexts.base.Priority;
import com.mlib.data.ISerializable;
import com.mlib.data.JsonListener;
import com.mlib.data.SerializableList;
import com.mlib.data.SerializableStructure;
import com.mlib.modhelper.AutoInstance;
import com.mlib.text.RegexString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

@AutoInstance
public class ArmorBleeding {
    final BooleanConfig availability = Condition.DefaultConfigs.excludable((boolean)true);
    final JsonListener.Holder<ArmorsDef> armorsDef = JsonListener.add((String)"custom", (ResourceLocation)Registries.getLocation("bleeding_armor"), ArmorsDef.class, ArmorsDef::new).syncWithClients(Registries.HELPER);

    public ArmorBleeding() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.BLEEDING).name("Armor").comment("Reduces Bleeding chance for each armor piece equipped (configurable via data pack).");
        OnBleedingCheck.listen(OnBleedingCheck.Data::cancel).priority(Priority.LOWEST).addCondition(Condition.excludable((BooleanConfig)this.availability)).addCondition(Condition.predicate(OnBleedingCheck.Data::isEffectTriggered)).addCondition(ArmorBleeding.tryItemChance(this.armorsDef)).insertTo(group);
        OnBleedingTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> this.availability.isEnabled())).addCondition(Condition.predicate(data -> ((ArmorsDef)this.armorsDef.get()).find(data.itemStack).isPresent())).insertTo(group);
    }

    private void addTooltip(OnBleedingTooltip.Data data) {
        data.addArmor(LivingEntity.m_147233_((ItemStack)data.itemStack), ((ArmorsDef)this.armorsDef.get()).find((ItemStack)data.itemStack).orElseThrow().chanceMultiplier);
    }

    private static Condition<OnBleedingCheck.Data> tryItemChance(Supplier<ArmorsDef> toolsDef) {
        return Condition.predicate(data -> {
            double chanceMultiplier = 1.0;
            for (EquipmentSlot slot : EquipmentSlots.ARMOR) {
                Optional<ArmorDef> armorDef = ((ArmorsDef)((Object)((Object)toolsDef.get()))).find(data.target.m_6844_(slot));
                if (!armorDef.isPresent()) continue;
                chanceMultiplier *= (double)armorDef.get().chanceMultiplier;
            }
            return Random.tryChance((double)(1.0 - chanceMultiplier));
        });
    }

    public static class ArmorsDef
    extends SerializableList {
        public List<ArmorDef> armorDefs = new ArrayList<ArmorDef>();

        public ArmorsDef() {
            this.defineCustom(() -> this.armorDefs, x -> {
                this.armorDefs = x;
            }, ArmorDef::new);
        }

        public Optional<ArmorDef> find(ItemStack itemStack) {
            return this.armorDefs.stream().filter(armorDef -> armorDef.matches(itemStack)).findFirst();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onClient(NetworkEvent.Context context) {
            Registries.HELPER.findInstance(ArmorBleeding.class).ifPresent(instance -> instance.armorsDef.onSync((ISerializable)this));
        }
    }

    public static class ArmorDef
    extends SerializableStructure {
        public RegexString id = new RegexString();
        public float chanceMultiplier;

        public ArmorDef() {
            this.defineString("id", () -> ((RegexString)this.id).get(), arg_0 -> ((RegexString)this.id).set(arg_0));
            this.defineFloat("chance_multiplier", () -> Float.valueOf(this.chanceMultiplier), x -> {
                this.chanceMultiplier = x.floatValue();
            });
        }

        public boolean matches(ItemStack itemStack) {
            return this.id.matches(Utility.getRegistryString((Item)itemStack.m_41720_()));
        }
    }
}

