/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.GameStageDoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnMobSpawnLimit;
import com.mlib.contexts.OnMobSpawnRate;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import net.minecraft.world.entity.MobCategory;

@AutoInstance
public class SpawnRateIncreaser {
    final GameStageDoubleConfig spawnRateMultiplier = new GameStageDoubleConfig(1.0, 1.1, 1.2, (Range<Double>)new Range((Number)0.0, (Number)10.0));

    public SpawnRateIncreaser() {
        ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("SpawnRate").comment("Increases spawn rate depending on current game stage.").addConfig((IConfigurable)this.spawnRateMultiplier);
        OnMobSpawnRate.listen(this::increaseSpawnRate).addCondition(OnMobSpawnRate.is((MobCategory[])new MobCategory[]{MobCategory.MONSTER}));
        OnMobSpawnLimit.listen(this::increaseSpawnLimit).addCondition(OnMobSpawnLimit.is((MobCategory[])new MobCategory[]{MobCategory.MONSTER}));
    }

    private void increaseSpawnRate(OnMobSpawnRate.Data data) {
        data.value = (float)((double)data.value * (Double)this.spawnRateMultiplier.getCurrentGameStageValue());
    }

    private void increaseSpawnLimit(OnMobSpawnLimit.Data data) {
        data.value = (int)((double)data.value * (Double)this.spawnRateMultiplier.getCurrentGameStageValue());
    }
}

