/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.GameStageStringListConfig;
import com.mlib.Utility;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnCheckSpawn;
import com.mlib.contexts.OnSpawned;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.modhelper.AutoInstance;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;

@AutoInstance
public class SpawnBlocker {
    final GameStageStringListConfig forbiddenEntities = new GameStageStringListConfig(new String[]{"minecraft:illusioner", "majruszsdifficulty:tank", "majruszsdifficulty:cerberus"}, new String[]{"majruszsdifficulty:cerberus"}, new String[0]);

    public SpawnBlocker() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("SpawnBlocker").comment("Makes mobs unable to spawn when given game stage is active (it only affects natural spawns).").addConfig((IConfigurable)this.forbiddenEntities);
        OnCheckSpawn.listen((Consumer)OnCheckSpawn.CANCEL).addCondition(Condition.predicate(data -> data.getSpawnType() == MobSpawnType.NATURAL)).addCondition(Condition.predicate(data -> this.isBlocked((Entity)data.mob))).insertTo(group);
        OnSpawned.listen((Consumer)OnSpawned.CANCEL).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(Condition.predicate(data -> data.getSpawnType() == MobSpawnType.NATURAL)).addCondition(Condition.predicate(data -> this.isBlocked((Entity)data.target))).insertTo(group);
    }

    private boolean isBlocked(Entity entity) {
        return ((List)this.forbiddenEntities.getCurrentGameStageValue()).contains(Utility.getRegistryString((EntityType)entity.m_6095_()));
    }
}

