/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.GameStageDoubleConfig;
import com.mlib.Utility;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.contexts.OnSpawned;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

@AutoInstance
public class MobsSpawnStronger {
    static final AttributeHandler MAX_HEALTH_ATTRIBUTE = new AttributeHandler("ba9de909-4a9e-43da-9d14-fbcbc2403316", "ProgressiveDifficultyHealthBonus", Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_BASE);
    static final AttributeHandler DAMAGE_ATTRIBUTE = new AttributeHandler("053d92c8-ccb5-4b95-9add-c31aca144177", "ProgressiveDifficultyDamageBonus", Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE);
    final GameStageDoubleConfig healthBonus = new GameStageDoubleConfig(0.0, 0.1, 0.2, (Range<Double>)new Range((Number)0.0, (Number)10.0));
    final GameStageDoubleConfig damageBonus = new GameStageDoubleConfig(0.0, 0.1, 0.2, (Range<Double>)new Range((Number)0.0, (Number)10.0));
    final GameStageDoubleConfig nightMultiplier = new GameStageDoubleConfig(1.5, 1.5, 1.5, (Range<Double>)new Range((Number)1.0, (Number)10.0));
    final StringListConfig excludedMobs = new StringListConfig(new String[0]);
    final StringListConfig excludedDimensions = new StringListConfig(new String[0]);

    public MobsSpawnStronger() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("MobsSpawnStronger").comment("All hostile mobs get damage and health bonuses.");
        OnSpawned.listen(this::makeMobsStronger).addCondition(Condition.isServer()).addCondition(Condition.excludable()).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(Condition.predicate(data -> this.canMobAttack(data.target))).addCondition(Condition.predicate(data -> this.isNotDimensionExcluded(data.getServerLevel()))).addCondition(Condition.predicate(data -> this.isNotMobExcluded(data.target))).addConfigs(new IConfigurable[]{this.healthBonus.name("HealthBonusMultiplier")}).addConfigs(new IConfigurable[]{this.damageBonus.name("DamageBonusMultiplier")}).addConfigs(new IConfigurable[]{this.nightMultiplier.name("NightMultiplier").comment("Multiplies health and damage bonuses at night.")}).addConfigs(new IConfigurable[]{this.excludedMobs.name("excluded_mobs").comment("List of mobs that should not get health and damage bonuses. (for instance minecraft:wither)")}).addConfigs(new IConfigurable[]{this.excludedDimensions.name("excluded_dimensions").comment("List of dimensions where health and damage bonuses should not be applied. (for instance minecraft:overworld)")}).insertTo(group);
    }

    private void makeMobsStronger(OnSpawned.Data data) {
        LivingEntity entity = data.target;
        double nightMultiplier = data.getServerLevel().m_46462_() ? (Double)this.nightMultiplier.get() : 1.0;
        MAX_HEALTH_ATTRIBUTE.setValue((Double)this.healthBonus.getCurrentGameStageValue() * nightMultiplier).apply(entity);
        DAMAGE_ATTRIBUTE.setValue((Double)this.damageBonus.getCurrentGameStageValue() * nightMultiplier).apply(entity);
        entity.m_21153_(entity.m_21233_());
    }

    private boolean canMobAttack(LivingEntity entity) {
        return entity instanceof Mob && AttributeHandler.hasAttribute((LivingEntity)entity, (Attribute)Attributes.f_22281_);
    }

    private boolean isNotDimensionExcluded(ServerLevel level) {
        return !this.excludedDimensions.contains(Utility.getRegistryString((Level)level));
    }

    private boolean isNotMobExcluded(LivingEntity entity) {
        return !this.excludedMobs.contains(Utility.getRegistryString((LivingEntity)entity));
    }
}

