/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.contexts.base.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.OnDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.levels.LevelHelper;
import com.mlib.modhelper.AutoInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.projectile.ThrownTrident;

@AutoInstance
public class DrownedLightningAttack {
    public DrownedLightningAttack() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("DrownedLightningAttack").comment("Drowned trident throw may spawn a lightning bolt when it rains.");
        OnDamaged.listen(this::spawnLightningBolt).addCondition(CustomConditions.gameStageAtLeast(GameStage.EXPERT)).addCondition(Condition.excludable()).addCondition(Condition.predicate(data -> data.attacker instanceof Drowned)).addCondition(Condition.predicate(data -> data.source.m_7640_() instanceof ThrownTrident)).addCondition(Condition.predicate(data -> LevelHelper.isEntityOutside((Entity)data.target))).addCondition(Condition.predicate(data -> LevelHelper.isRainingAt((Entity)data.target))).insertTo(group);
    }

    private void spawnLightningBolt(OnDamaged.Data data) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(data.target.f_19853_);
        if (lightningBolt == null) {
            return;
        }
        lightningBolt.m_20248_(data.target.m_20185_(), data.target.m_20186_(), data.target.m_20189_());
        data.target.f_19853_.m_7967_((Entity)lightningBolt);
    }
}

